/*////////////////////////////////////////////////////////////////////
//
//  file: asmflexbase.ll
//
//
//  Project Lissom
//  
//  FIT VUT Brno 
//
//  basic part of lexical analyzer
//  contains definitions of constant numbers and
//  another tokens definitios from the assembler language
//  needs to be combined with flex source generated by parser
//  generator
//  
//  author:  Adam Husar, xhusar01@stud.fit.vutbr.cz
//  created: 24.03.2005
//  last change: 28.11.2005
//
//  changelist:
//
////////////////////////////////////////////////////////////////////
*/


%option outfile="asmscanner.cpp"
%option case-insensitive
   
%option nostdinit

%{
// specify other type of yychar
#define YYSTYPE isaccpointer

#include "codegen.h"
#include "asmparser.hpp"

#define YY_DECL int asmscanner()

extern CCodeGen* codegen;

bool is_first_codingrootnonterm;	// first codingroot nonterminal's signalisation

/*YY_BUFFER_STATE my_buffer;*/
%}

  
D  [0-9]
L  [a-zA-Z_]
H  [a-fA-F0-9]
B  [01]
  

 
%% 

"IMPORT"        return EXTERN;
"EXPORT"        return PUBLIC;
"SECTION"       return SECTION;
".TEXT"         return SECTION_TYPE_TEXT;
".DATA"         return SECTION_TYPE_DATA;
"NAME"          return SECTION_NAME;
=               return SECTION_NAME_DELIM;
"ORG"           return SECTION_ORG;
:               return LABEL_DELIM;

{L}({L}|{D})*   yylval = (int) codegen->SymbolDup(yytext); return SYMBOL;
\"[^\"]*\"      yylval = (int) codegen->StringDup(yytext); return STRING;

[+|-]?{D}+      return DEC_CONST;
0[xX]{H}+       return HEX_CONST;
0[bB]{B}+       return BIN_CONST;

"\n"         {
                codegen->IncLine(); 
                return NEWLINE;
             }


[ \t]        /* eat-up whitespace */
.            { 
                codegen->Error("unexpected character %c.", *yytext);
                return *yytext;
             }

%%
   

int yywrap()
{
    return 1;
}


void ScannerInit()
{
	is_first_codingrootnonterm = true;
}
   
void ScannerSelectInput(FILE* fin)
{
    yyin = fin;

/*  my_buffer = yy_create_buffer(fin, YY_BUF_SIZE);*/

/*  yy_switch_to_buffer(my_buffer);*/
}

void ScannerClose()
{
  /*yy_delete_buffer(my_buffer);*/
}
