/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version "0.1"    Header/source file for the project   "socket.h"         *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/
 
#ifndef Socket_class
#define Socket_class

#include <sys/types.h>

#ifndef WIN32
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <netdb.h>
  #include <arpa/inet.h>
#else
  #include <winsock.h>
#endif

#include <unistd.h>
#include <string>
#include "xmltransutils.h"
#include "comlayer.h"

const int MAXHOSTNAME = 200;
const int MAXCONNECTIONS = 10;
const int MAXRECV = 500;

class Socket: public COMLAYER
{
public:
  	Socket();
  	~Socket();

  	// Server initialization
  	bool create();
  	bool bind ( int port );
  	bool listen();
  	bool accept (COMLAYER *new_cmpl);

  	// Client initialization
  	bool connect ( char *host,int port );


	// mas: 250805, first 4B reserved for data size in stream
  	// Data Transimission
  	int send ( ShContainer *s);
  	
	// mas: 250805, first 4B reserved for data size in stream
  	// TODO: solve the endien problem for the 4B of data size
  	int recv ( ShContainer *s);

  	void set_non_blocking (bool );
  	bool is_valid() { return m_sock != -1; }
  	int getError() { return error; }
  	void unaccept();
    // mas: 05052007, added get_fd() - needed for select()
    int get_fd();
  
private: 
  	int m_sock;
  	sockaddr_in m_addr;
 	int error;
};

#endif
