/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version number    Header/source file for the project   "file name"     *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/
 
#ifndef _MESSAGES_H_INCLUDED_
#define _MESSAGES_H_INCLUDED_

#define MAX_ERRORMSG_LEN 512

class CMessages{
	public:
		CMessages();
		~CMessages();
	
		/*-initialization an deinitialization of error/warnings system
		//and maybe of some other things
		*/
		void MessagesInit();
		void MessagesClose();		

		/* ----------------  error messages functions ---------------- */
		
		/*error, warning and message functions */
		
		/* prints message and terminates parser */
		void FatalError(char* sMsg, ...);
		
		/* prints message and stops code generating */
		void Error(char* sMsg, ...);
		
		void Warning(char* sMsg, ...);
		void Message(char* sMsg, ...);
		
		
		/* - prints if was compilation succesfull and also prints numbers of errors, warnings, ... */
		/* - returns true if count of errors is zero */
		/* - if parameter bPrinfIfOK is FALSE and count of errors is zero, then nothing is printed */
		bool PrintFinalResume(const bool bPrintIfOK);
		
		bool IsSuccesful();
		
		/* ----------------- filename / line functions --------------- */
		
		void ResetLine();
		void IncLine();
		void SetLine(const int nLine);
		int  GetLine();
		
		
		void  SetFileName(const char* sName);
		char* GetFileName();
		
	private:
		
		int m_nError_cnt;
		int m_nWarning_cnt;
		int m_nMessage_cnt;
		
		int m_nLine; 
		char* m_sFileName;
	
};

#endif
