/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version number    Header/source file for the project   "isacexceptions.h"  *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/

#ifndef ISACEXCEPTIONS_H_
#define ISACEXCEPTIONS_H_

// standard exceptions
#include <iostream>
#include <exception>
#include <stdexcept>
#include <sstream>
#include <string>

using namespace std;

namespace IsacExceptions
{
    //! Obecna vyjimka.
    class general_error : public exception
    {
    public:
        ~general_error() throw()
        {
        }

        general_error(string sMessage = "")
        {
            m_sMessage = string("General error: ") + sMessage;
        }

        virtual const char* what() const throw()
        {
            return m_sMessage.c_str();
        }

    private:
        string     m_sMessage;
    };

    class iparam_error : public exception
    {
    public:
        ~iparam_error() throw()
        {
        }

        iparam_error(string sMessage = "")
        {
            m_sMessage = string("Error in program parameters: ") + sMessage;
        }

        virtual const char* what() const throw()
        {
            return m_sMessage.c_str();
        }

    private:
        string     m_sMessage;
    };

	class xml_error : public exception
    {
    public:
        ~xml_error() throw()
        {
        }

        xml_error(string sMessage = "")
        {
            m_sMessage = string("XML error: ") + sMessage;
        }

        virtual const char* what() const throw()
        {
            return m_sMessage.c_str();
        }
    private:
       	string     m_sMessage;
    };

    class syntactic_error : public exception
    {
    public:
        ~syntactic_error() throw()
        {
        }

        syntactic_error(string sMessage = "")
        {
            m_sMessage = string("Syntax error: ") + sMessage;
        }

        virtual const char* what() const throw()
        {
            return m_sMessage.c_str();
        }

    private:
        string     m_sMessage;
    };    

};
  
#endif /*ISACEXCEPTIONS_H_*/
