/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version number    Header/source file for the project   "file name"     *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/

#ifndef _ISACCTYPES_H_INCLUDED_
#define _ISACCTYPES_H_INCLUDED_

// data type used by the simulator and ISAC compiler
typedef long long int isaccint;

// the pointer's type has to reflect the architecture  
#if defined(_OS64)  
typedef long long int isaccpointer;
#else 	// _OS64
typedef int isaccpointer;
#endif  // _OS64

typedef unsigned int UINT;
typedef int SINT;

// prototype of scanner's functions' pointer
typedef int (*TINSTRSCANFNC)();  

// prototype of OPERATION for compiled simulator
typedef int (*TCMPSIMFNC)(); 

// find the halt keyword in the BEHAVIORAL or EXPRESSION section of the operation and set up proper action
static const char* DSMSIMP_HALTSYMBOL = "SIMHALT";
static const char* DSMSIMP_HALTACTION = "dbg_obj()->set_halt(true);";

#define ISACCTYPES_FILE_H "isacctypes.h"

// definition of common generated file names
#define DEFAULT_YACC_OUTPUT_FILE_CPP "defaultparser.cpp"
#define DEFAULT_YACC_FILE_H "defaultparser.h"
#define DEFAULT_SCANER_FILE_H "defaultscanner"

#define USEDATTR_FILE_H "usedattr.h"
#define USEDATTR_FILE_CPP "usedattr.cpp"
#define KNITTINGALG_FILE_H "dsmknittingalg.h"
#define UTILS_FILE_H "dsmutils.h"

#define DSML_FILE_H "dsml.h"
#define ISIML_FILE_H "isiml.h"
#define DBGL_FILE_H "dbgl.h"
#define RESDECL_FILE_H "res_decls.h"
#define RSTATL_FILE_H "rstatl.h"

#define DSM_PARS_FILE_CPP "dsmparser.cpp"
#define DSM_PARS_FILE_H "dsmparser.h"
#define DSM_HELPSCAN_FILE_H "dsmscanl.h"
#define DSM_SCAN_FILE_H "opschedull.h"

#define SIM_RES_MODEL_NAME "cpu_res"
#define SIM_RES_FILE_H "cpu_res.h"
#define SIM_RES_FILE_CPP "cpu_res.h"

#define INTSIM_PARS_FILE_YY "intersimparser.yy"
#define INTSIM_PARS_FILE_CPP "intersimparser.cpp"
#define INTSIM_PARS_FILE_H "intersimparser.h"
#define INTSIM_SCAN_FILE_H "opschedull.h"

#define CMPSIM_BEH_FILE_H "cpubeh.h"
#define CMPSIM_BEH_FILE_CPP "cpubeh.cpp"
#define CMPSIM_OPLIST_FILE_H "cpu_oplist.h"
#define CMPSIM_OPSCHEDULL_FILE_H "opschedull.h"

#define CMPSIM_BASE_FILE_H "cmpsim.h"
#define CMPSIM_SETUP_FILE_H "cmpsimsetup.h" 

#define CMPSIM_PARS_FILE_YY "cmpsimparser.yy"
#define CMPSIM_PARS_FILE_CPP "cmpsimparser.cpp"
#define CMPSIM_PARS_FILE_H "cmpsimparser.h"
#define CMPSIM_SCAN_FILE_H "opschedull.h" 	// use the disassembler scanner
/*#define CMPSIM_CPUFNC_FILE_H "cmpsimbeh.h"
#define CMPSIM_CPUFNC_FILE_CPP "cmpsimbeh.cpp"*/
//#define CMPSIM_CPUCR_FILE_H "cpucr.h"
//#define CMPSIM_CPUCR_FILE_CPP "cpucr.cpp"

// mas: 161106 - disable support of compiled call simulator 
#if (defined SUPCMPCALLSIM)
#define CMPSIM_CPUFNC_CALL_CPP "cpu_functions.cpp"
#define CMPSIM_CPUFNC_CALL_H "cpu_functions.h"
#endif // SUPCMPCALLSIM 


//there are different types of simulators
const int TSIMNONE = 0;
const int TDSM	= 1;	//no simulator selected, dsm will be generated
const int TASM	= TDSM<<1;	//no simulator selected, asm will be generated
const int TINTRSIM = TDSM<<2;  // interpretting simulator
const int TCMPBASICSIM = TDSM<<3; // compiled simulator

// mas: 161106 - disable support of compiled call simulator 
#if (defined SUPCMPCALLSIM)
const int TCMPCALLSIM = ((TDSM<<4) | TCMPBASICSIM) ; // compiled simulator with the call of instruction's behavioral function 
#endif // SUPCMPCALLSIM 

const int TCMPFASTSIM = ((TDSM<<5)| TCMPBASICSIM); // fast compiled simulator  

static const char *TINTRSIM_STRVAL = "intersim";

// mas: 161106 - disable support of compiled call simulator 
#if (defined SUPCMPCALLSIM)
static const char *TCMPCALLSIM_STRVAL= "cmpcallsim";
#endif // SUPCMPCALLSIM 

static const char *TCMPFASTSIM_STRVAL = "cmpfastsim";

#endif
