/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version "0.1"    Header/source file for the project   "comlayer.h"       *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/
 
#ifndef COMLAYER_H_
#define COMLAYER_H_

#include "xmltransutils.h"

/* type of communication layer */
typedef enum tagCOMLAYRTYPE{
	COMLAYER_TCPIP,COMLAYER_IPC		
}COMLAYRTYPE;

static const char COMLAYRTYPE_STR[2][32] = {"TCPIP","IPC"}; 

class COMLAYER
{
public:
	virtual bool create()=0;	
	virtual bool bind (int port)=0;	
	virtual	bool listen ()=0; 
	virtual	bool accept (COMLAYER *new_comlayer)=0;
	virtual	bool connect (char *host, const int port)=0;	
	virtual	int send (ShContainer * s)=0;
	virtual	int recv (ShContainer * s)=0;	
	virtual	bool is_valid()=0;
	virtual int getError()=0;
	virtual void unaccept()=0;
};
#endif /*COMLAYER_H_*/
