/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version number    Header/source file for the project   "file name"     *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/
 

//  part assembler generator
//    contains interface of some auxiliary functions that
//  are used by the parser
//  
//  author:  Adam Husar, xhusar01@stud.fit.vutbr.cz
//  created: 27.03.2005
//  last change: 27.03.2005
//
//  changelist:
// 		20.7.2006 - Zdenek Prikryl, xprikr09@.stud.fit.vutbr.cz
// 		 + rewrite to cpp
//
////////////////////////////////////////////////////////////////////

#ifndef _UTILS_H_INCLUDED_
#define _UTILS_H_INCLUDED_

#include "isacctypes.h"
#include "messages.h"

class CUtils : public CMessages{
	public:
		CUtils() {}
		~CUtils() {}		
		/* ------------------  string functions --------------------- */		
		char * StringDup(const char * str);
		char * SymbolDup(const char * str);
		
		void StringFree(char * str);
		void SymbolFree(char * str);		
		/* --------------  conversion functions --------------------- */
		
		/*-converts num to binary string, checks if the number does fit into
		//max_bits ... if not, the result is truncated and an warning message
		//is printed
		//-you must deallocate the returned string
		//TODO: add selection of endianess - now it converts everything to big-endian\
		*/
		char* ConvUnsignToBin(const UINT num, const int max_bits); 
		/* converts number into binary string coded in one's complement coding */
		char* ConvSignToBin(const int num, const int max_bits); 
		
};



#endif /* #ifndef _UTILS_H_INCLUDED_ */
