#!/bin/sh

# $1 -> work dir
# $2 -> in file
# $3 -> out file

if [ $# -eq 3 ]; then
		
	ROOT_DIR=$1
	SRC=$2
	DST=$3
	
	if [ ! -f project/$ROOT_DIR/tools/assembler/linux/asm ]; then
        echo "Application of the assembler doesn't exist"
	    exit
	 fi
	
	#for linux define the directory with libraries
	export LD_LIBRARY_PATH=lib 2>&1

	# for windows define the directory with libraries
	export PATH=lib 2>&1
	     
	#run asm
	project/$ROOT_DIR/tools/assembler/linux/./asm -i $SRC -o $DST 2>&1

else
	DSTPROG=`find $0 -printf %f`;
    echo "Usage: $DSTPROG <project> <input file> <output file>"
fi
