from .StringType import StringType
import sys


class VotesNameChangeStringtype(StringType):
    """Class that changes vote values"""
    def __init__(self, value,vote_for,vote_against,vote_missing,vote_not_voting,vote_abstained,vote_excused) -> None:
        super().__init__(value)
        self.vote_for = vote_for
        self.vote_against = vote_against
        self.vote_missing = vote_missing
        self.vote_not_voting = vote_not_voting
        self.vote_abstained = vote_abstained
        self.vote_excused = vote_excused

    def get_value(self)-> str:
        value =  super().get_value()
        if value == self.vote_for:
            return "A"
        elif value == self.vote_against:
            return "N"
        elif value == self.vote_missing:
            return "–"
        elif value == self.vote_not_voting:
            return "X"
        elif value == self.vote_abstained:
            return "Z"
        elif value == self.vote_excused:
            return "O"
        else:
            print(f'"{value} is not known value check the metafile if u have set it up correctly!"',file=sys.stderr)
            raise ValueError
