from .StringType import StringType
from datetime import datetime


class TimeStringType(StringType):
    """Class that return time from value"""
    def __init__(self,value,datetime_format) -> None:
        super().__init__(value)
        self.datetime_format = datetime_format

    def get_value(self)-> str:
        try: 
            value =  super().get_value()
            date_time = datetime.strptime(value, self.datetime_format)
            time = date_time.time()
            #format time as H:M:S
            return time.strftime('%H:%M:%S')
        except:
            return super().get_value()