from .StringType import StringType
import re
from datetime import datetime


class RegexTimeStringType(StringType):
    """Class that gets value by regex and returns time from value"""
    def __init__(self,value,regex,datetime_format) -> None:
        super().__init__(value)
        self.regex = regex
        self.datetime_format = datetime_format

    def get_value(self)-> str:
        try: 
            value =  super().get_value()
            value = re.search(self.regex, value)
            value = value.group(0)
            date_time = datetime.strptime(value, self.datetime_format)
            time = date_time.time()
            #format time as H:M:S
            return time.strftime('%H:%M:%S')
        except:
            return super().get_value()