from .StringType import StringType
import re

"""Class that splits values into 2 strings by regex"""
class RegexSplitStringType(StringType):
    def __init__(self, value,split_regex,index) -> None:
        super().__init__(value)
        self.split_regex = split_regex
        self.index = index

    def get_value(self)-> str:
        value =  super().get_value()
        splitted = re.split(self.split_regex,value)
        try:
            return splitted[self.index]
        except IndexError:
            return super().get_value()