from .StringType import StringType
import re

class RegexSplitAndConcatStringType(StringType):
    """Class that splits values into 2 strings by regex and by two indexes combines them"""
    def __init__(self, value,split_regex,index1,index2) -> None:
        super().__init__(value)
        self.split_regex = split_regex
        self.index1 = index1
        self.index2 = index2

    def get_value(self)-> str:
        value =  super().get_value()
        splitted = re.split(self.split_regex,value)
        return splitted[self.index1]+splitted[self.index2]