from .StringType import StringType
import re

 
class RegexFindAllStringType(StringType):
    """Class that return list of all values that match regex"""
    def __init__(self, value,find_regex,index) -> None:
        super().__init__(value)
        self.find_regex = find_regex
        self.index = index

    def get_value(self)-> str:
        value =  super().get_value()
        found = re.findall(self.find_regex,value)
        try:
            return found[self.index]
        except IndexError:
            return super().get_value()