from .StringType import StringType
import sys
import os

class FunctionStringType(StringType):
    def __init__(self, value, function_name:str, function_parameters:list, file_path) -> None:
        super().__init__(value)
        self.function_name = function_name
        self.function_parameters = function_parameters
        self.file_path = file_path
    
    def get_value(self) -> str:
        if not os.path.isfile(self.file_path):
            raise FileNotFoundError(f"File config._user_function_file -- ({self.file_path}) does not exist.")
        
        with open(self.file_path, 'r') as file:
            user_fnc_file = file.read()
        try:
            local_namespace = {}
            exec(user_fnc_file, local_namespace)
            return local_namespace[self.function_name](self.value,*self.function_parameters if self.function_parameters is not None else [])
        except:
            print(f"Something went wrong with FunctionStringType. You may want to check the values in the metafile. Those values are:",file=sys.stderr)
            print(f"Function name:{self.function_name},Function parameters:{self.function_parameters}, value:{self.value}",file=sys.stderr)
            print("\n",file=sys.stderr)
            return super().get_value()