from .StringType import StringType
from datetime import datetime


class DateStringType(StringType):
    """Class that return date from value"""
    def __init__(self, value,datetime_format) -> None:
        super().__init__(value)
        self.datetime_format = datetime_format

    def get_value(self)-> str:
        try:
            value =  super().get_value()
            date_time = datetime.strptime(value, self.datetime_format)
            date = date_time.date()
            #format date as YYYY-MM-DD
            return date.strftime('%Y-%m-%d')
        except:
            return super().get_value()