from .CommonParser import CommonParser
import re
import sys

class TreeFileParser(CommonParser):
    """
    Class for parsing json/xml
    """
    def __init__(self, metafile,one_file=False,filename="",by_sittings_or_more = False):
        super().__init__(metafile,one_file,filename,by_sittings_or_more)

    def parse_file(self,data):
        """
        Parse input file

        Parameters:
            data: data to be parsed
        """
        self.data = data
        #TODO hotfix - fix circularity
        from src.Cleaning.Data_clean import DataClean
        data_clean = DataClean(self.data,self.metafile_data)
        self.data = data_clean.clean_data()
        self.get_municipality()
        self.get_political_subjects()
        self.get_deputies_data()
        self.get_votings_data()
        self.count_result_of_all_votings()
        self.get_validity_of_all_votings()
        self.give_voting_number_to_all_votings()
        print(self.output_data)
        self.give_ids(self.output_data['politickeSubjekty'],'id')
        self.give_ids(self.output_data['zastupitele'],'id')
        self.assign_ids_to_deputies_votes()
        self.delete_one_of()
        self.delete_deputies_with_no_party()
        self.split_output_by_date()
        self.update_deputies_id()
        return self.output_data
    
    def remove_extra_brackets(self,lst):
        """
        Method that recursively removes extra unnecessary brackets

        lst: list to be cleaned 
        """
        if isinstance(lst, list):
            if len(lst) == 1:
                return self.remove_extra_brackets(lst[0])
            else:
                return [self.remove_extra_brackets(item) for item in lst]
        else:
            return lst
        
    def make_list_one_dimension(self,input_list):
        """
        Method for flattening list into one dimenstion

        Parameters:
        input_list: list to be changed
        """
        flattened = []
        if not isinstance(input_list, list):
            input_list = [input_list]
        for item in input_list:
            if isinstance(item, list):
                flattened.extend(self.make_list_one_dimension(item))
            else:
                flattened.append(item)
        return flattened
    
    def convert_value_to_key(self,data,key_is_value=None):
        """
        Method for converting value to its key
        """
        if key_is_value is None:
            return data
        
        data = [key_is_value for _ in range(len(data))]
        return data
    
    def search_square_bracket(self, string):
        """
        Method for trying to find square bracket in tree part string for indexing
        """
        pattern = r'([^\[]+)\[([^\]]+)\]'
        # check if there is something with the square brackets
        found = re.match(pattern, string)
        if found:
        # if there is something return value of the key, square bracket and type of value in square bracket 
            val_type = self.get_type_of_square_brackets_value(found.group(2))
            return found.group(1), val_type[0], val_type[1]
        else:
        #if there is no square bracket return string
            return string, None, -1
        
    def get_type_of_square_brackets_value(self,string):
        """
        Method for finding what the type of value of value in square bracket is
        """
        pattern_integer = r'^[-+]?\d+$'
        pattern_string_cond = r"([^=]+)='([^']*)'"
        pattern_integer_from_to = r"^\d*:\d*$"
        
        if bool(re.match(pattern_integer,string)):
            return int(string), 1
        elif bool(re.match(pattern_string_cond,string)):
            matched = re.match(pattern_string_cond,string)
            return [matched.group(1),matched.group(2)], 2
        elif bool(re.match(pattern_integer_from_to,string)):
            splitted = string.split(":")
            if splitted[0] == "":
                splitted[0] = sys.minsize
            if splitted[1] == "":
                splitted[1] = sys.maxsize
            splitted[0] = int(splitted[0])
            splitted[1] = int(splitted[1])
            return splitted,3
        else:
            return string, -2



    def get_data_in_tree(self, tree_position:str,key:str,value_type=None,value_params=None,key_is_value=False,list_type=None,make_list_one_dimension=None):
        """
        Method that gets data that is written in a tree
        """
        list_of_tree_parts = self.split_string_by_viable_split_chars(tree_position)
        data_of_one_part = []
        self.recursively_search_tree(self.data,list_of_tree_parts,data_of_one_part,key,value_type,value_params,key_is_value,list_type,make_list_one_dimension)
        data_of_one_part = self.remove_extra_brackets(data_of_one_part)
        if list_type is not None:
            #the value is usually just one, it needs extra bracket removal
            data_of_one_part = self.remove_extra_brackets(self.apply_list_type_rule_on_list(data_of_one_part,key,list_type))
        return data_of_one_part
    
    def assign_key_to_lowest_list(self,lst, key):
        """
        Method for taking the lowest list in nested list of list structure and giving it key

        Parameters:
        lst: list that needs to be searched through
        key: key name
        """
        if not isinstance(lst, list):
            raise ValueError("Input must be a list")
        if all(isinstance(item, list) for item in lst):
            return [self.assign_key_to_lowest_list(item, key) for item in lst]
        else:
            return {key: lst}
            

    def recursively_search_tree(self, data, list_of_tree_parts, result_list, key, value_type=None, value_params=None,key_is_value=False,list_type=None, make_list_one_dimension=None, last_part_index=-1):
        """
        Method that recursively searches through tree of file
        """

        #initial value for further parsing
        initial_lotp = list_of_tree_parts[0][0]
        searched_square_bracket = self.search_square_bracket(list_of_tree_parts[0][0])
        if searched_square_bracket[2] < 0:
            list_of_tree_parts[0][0] = searched_square_bracket[0]
        # index selection in list
        elif searched_square_bracket[2] == 1:
            list_of_tree_parts[0][0] = searched_square_bracket[0]
        # conditional selection if attribute in tag is of certain value
        elif searched_square_bracket[2] == 2:
            list_of_tree_parts[0][0] = searched_square_bracket[0]
        elif searched_square_bracket[2] == 3:
            list_of_tree_parts[0][0] = searched_square_bracket[0]
        else:
            print(searched_square_bracket)

        if self.metafile_data['config']['format'] == 'html':
            # try go further even if there is a error, it is viable with HTML
            try:
            #if is not list, try going further, in HTML it is viable
                if isinstance(data[list_of_tree_parts[0][0]], dict) and list_of_tree_parts[0][1] == '.':
                    return
            except (KeyError, TypeError):
                #set back to initial value
                list_of_tree_parts[0][0] = initial_lotp
                return
         
        if list_of_tree_parts[0][1] == ".":
            for index, element in enumerate(data[list_of_tree_parts[0][0]]):
                #if the index of element is of wanted index in square brackets or the was no index specified inspect further
                if (searched_square_bracket[1] == index) or searched_square_bracket[2] == -1 or (searched_square_bracket[2] == 3 and searched_square_bracket[1][0] <= index < searched_square_bracket[1][1]):
                    nested_result_list = []
                    self.recursively_search_tree(element, list_of_tree_parts[1:], nested_result_list, key, value_type, value_params,key_is_value,list_type,make_list_one_dimension,index)
                    result_list.append(nested_result_list)
                #set the selector back to initial value
                list_of_tree_parts[0][0] = initial_lotp
        elif list_of_tree_parts[0][1] == "":
            #if there is condition for certain atribute in HTML tag
            if searched_square_bracket[2] == 2:
                #value of dictionary is not the one needed
                if data[searched_square_bracket[1][0]] != searched_square_bracket[1][1]:
                    #set selector back to initial value
                    list_of_tree_parts[0][0] = initial_lotp
                    return
            return_value = self.convert_string_to_list(data[list_of_tree_parts[0][0]])
            if key_is_value:
                one_part = self.convert_value_to_key(data[list_of_tree_parts[0][0]],list_of_tree_parts[0][0])
            return_value = self.apply_type_rule_on_list(return_value, value_type, value_params)
            if make_list_one_dimension is not None:
                return_value = self.make_list_one_dimension(return_value)
            return_value = self.make_list_of_dicts_out_of_list_of_lists(return_value,key)
            if return_value is not None:
                result_list.append(return_value)  # append the result to the result_list

            #set the selector back to initial value
            list_of_tree_parts[0][0] = initial_lotp
        elif list_of_tree_parts[0][1] == "|":
            list_of_parts = []
            for part in list_of_tree_parts:
                if data.get(part[0]) is not None:
                    one_part = self.convert_string_to_list(data[part[0]])
                    if key_is_value:
                        one_part = self.convert_value_to_key(data[part[0]],part[0])
                    one_part = self.apply_type_rule_on_list(one_part, value_type, value_params)
                    one_part = self.make_list_of_dicts_out_of_list_of_lists(one_part,key)
                    list_of_parts = list_of_parts + one_part
            result_list.append(list_of_parts)
        elif list_of_tree_parts[0][1] == "+":
            list_of_parts = []
            one_part = ""
            for index, part in enumerate(list_of_tree_parts):
                copied_part = part.copy()
                result = re.split(r'(!)', copied_part[0])
                result = [s for s in result if s]
                if len(result) == 2:
                    copied_part[0] = result[0]


                if data.get(copied_part[0]) is not None:
                    if isinstance(data.get(copied_part[0]),list) and len(data.get(copied_part[0])) == 1:
                        data[copied_part[0]] = data[copied_part[0]][0]
                    #if there is an exclamation mark (!) apply rule on concrete attribute
                    if len(result) == 2:
                        data[copied_part[0]] = self.apply_type_rule_on_list(data[copied_part[0]], value_type, value_params)
                    one_part = one_part + "#" + data[copied_part[0]]
            one_part = self.convert_string_to_list(one_part)
            if key_is_value:
                one_part = self.convert_value_to_key(data[part[0]],part[0])
            one_part = self.apply_type_rule_on_list(one_part, value_type, value_params)
            one_part = self.make_list_of_dicts_out_of_list_of_lists(one_part,key)
            result_list.append(one_part)
        elif list_of_tree_parts[0][1] == "`":
            self.recursively_search_tree(data[list_of_tree_parts[0][0]], list_of_tree_parts[1:], result_list, key, value_type, value_params,key_is_value,list_type,make_list_one_dimension)
        else:
            print(f"Check your metafile -- unknown delimiter (viable are: \".\",\"|\",\"`\")", file=sys.stderr)

            
    def split_string_by_viable_split_chars(self,string)->list:
        """
        Method for splitting string of position in list by certain characters

        Parameters:
        string (str): string to be splitted 
        """
        result = []
        delimiters = [".","`","|","+","*"]
        current_split = ""
        for char in string:
            if char in delimiters:
                result.append([current_split, char])
                current_split = ""
            else:
                current_split += char
        # last split is empty
        if current_split:
            result.append([current_split, ""])
        return result


    def get_municipality(self):
        if self.metafile_data['municipalita'].get('data') is not None:
            self.output_data['municipalita'] = self.metafile_data['municipalita']['data']
        print("INFO: Finished parsing \"municipalita.data\"")


    def get_political_subjects(self):
        """
        Method for getting info about politicalsubjects
        """
        if self.metafile_data.get('politickeSubjekty') is None:
            print(f"ERROR: missing specification for \"politickeSubjekty\"")
            exit(1)
        if self.metafile_data['politickeSubjekty'].get('data') is not None:
            self.output_data['politickeSubjekty'] = self.metafile_data['politickeSubjekty']['data']
            print("INFO: Added \"politickeSubjekty\" data")
            return
        
        parties = []
        colour = []
        if self.metafile_data['politickeSubjekty'].get('zkrNazev') is None:
            print(f"ERROR: missing specification for \"politickeSubjekty.ZkrNazev\"")
            exit(1)
        if self.metafile_data['politickeSubjekty']['zkrNazev'].get('data') is not None:
            parties = self.metafile_data['politickeSubjekty']['zkrNazev']['data']
            parties = self.metafile_data['politickeSubjekty']['zkrNazev'].copy()
            parties = self.give_dicts_key(parties['data'],'zkrNazev')
        else:
            parties = self.make_list_one_dimension(self.get_data_in_tree(self.metafile_data['politickeSubjekty']['zkrNazev']['tree_position'],
                                                                           'zkrNazev',
                                                                           self.metafile_data['politickeSubjekty']['zkrNazev'].get('_type'),
                                                                           self.metafile_data['politickeSubjekty']['zkrNazev'].get('parameters'),
                                                                           self.metafile_data['politickeSubjekty']['zkrNazev'].get('_key_is_value'),
                                                                           self.metafile_data['politickeSubjekty']['zkrNazev'].get('_list_type'),
                                                                           self.metafile_data['politickeSubjekty']['zkrNazev'].get('_make_list_one_dimension')))
            parties = self.remove_duplicates_in_list_of_dicts(parties)
        print("INFO: Added \"politickeSubjekty.zkrNazev\" data")

        if self.metafile_data['politickeSubjekty'].get('barva') is None:
            print(f"WARNING: missing specification for \"politickeSubjekty.barva\"")
        else:     
            if self.metafile_data['politickeSubjekty']['barva'].get('data') is not None:
                if self.one_file == True:
                    colour = self.metafile_data['politickeSubjekty']['barva'].copy()
                    colour = self.give_dicts_key(colour['data'],'barva')
            else:
                colour = self.make_list_one_dimension(self.get_data_in_tree(self.metafile_data['politickeSubjekty']['barva']['tree_position'],
                                                                            'barva',
                                                                            self.metafile_data['politickeSubjekty']['barva'].get('_type'),
                                                                            self.metafile_data['politickeSubjekty']['barva'].get('parameters'),
                                                                            self.metafile_data['politickeSubjekty']['barva'].get('_key_is_value'),
                                                                            self.metafile_data['politickeSubjekty']['barva'].get('_list_type'),
                                                                            self.metafile_data['politickeSubjekty']['barva'].get('_make_list_one_dimension')))
                colour = self.remove_duplicates_in_list_of_dicts(colour)
        print("INFO: Added \"politickeSubjekty.barva\" data")
        if self.one_file == True and self.metafile_data['politickeSubjekty'].get('barva') is not None:    
            self.output_data['politickeSubjekty'] = self.combine_list_of_dicts(colour,parties)
        else:
            self.output_data['politickeSubjekty'] = parties
        print("INFO: Finished parsing of \"politickeSubjekty\" data")
        print(self.output_data['politickeSubjekty'])
        print("\n")
        return


    def get_deputies_data(self):
        #if all info is written in metafile return immediately
        if self.metafile_data['zastupitele'].get('data') is not None:
            self.output_data['zastupitele'] = self.metafile_data['zastupitele']['data']
            return
        

        if self.metafile_data.get('zastupitele') is None:
            print(f"ERROR: missing specification for \"zastupitele\"")
            exit(1)
        # last name
        if self.metafile_data['zastupitele'].get('prijmeni') is None:
            print(f"ERROR: missing specification for \"zastupitele.prijmeni\"")
            exit(1)
        if self.metafile_data['zastupitele']['prijmeni'].get('data') is not None:
            last_name = self.metafile_data['zastupitele']['prijmeni']['data']
        else:
            last_name = self.make_list_one_dimension(self.get_data_in_tree(self.metafile_data['zastupitele']['prijmeni']['tree_position'],
                                                                           'prijmeni',
                                                                           self.metafile_data['zastupitele']['prijmeni'].get('_type'),
                                                                           self.metafile_data['zastupitele']['prijmeni'].get('parameters'),
                                                                           self.metafile_data['zastupitele']['prijmeni'].get('_key_is_value'),
                                                                           self.metafile_data['zastupitele']['prijmeni'].get('_list_type'),
                                                                           self.metafile_data['zastupitele']['prijmeni'].get('_make_list_one_dimension')))
        print("INFO: Added \"zastupitele.prijmeni\" data")
        # first name 
        if self.metafile_data['zastupitele'].get('jmeno') is None:
            print(f"ERROR: missing specification for \"zastupitele.jmeno\"")
            exit(1)
        if self.metafile_data['zastupitele']['jmeno'].get('data') is not None:
            first_name = self.metafile_data['zastupitele']['jmeno']['data']
        else:
            first_name = self.make_list_one_dimension(self.get_data_in_tree(self.metafile_data['zastupitele']['jmeno']['tree_position'],
                                                                            'jmeno',
                                                                            self.metafile_data['zastupitele']['jmeno'].get('_type'),
                                                                            self.metafile_data['zastupitele']['jmeno'].get('parameters'),
                                                                            self.metafile_data['zastupitele']['jmeno'].get('_key_is_value'),
                                                                            self.metafile_data['zastupitele']['jmeno'].get('_list_type'),
                                                                            self.metafile_data['zastupitele']['jmeno'].get('_make_list_one_dimension')))
        
        first_name = self.combine_list_of_dicts(first_name,last_name)
        #print(first_name,file=sys.stderr)

        #TODO duplicate names in a file that is not a single line
        if self.by_sittings_or_more == True:
            first_name = self.remove_duplicates_in_list_of_dicts(first_name)
        print("INFO: Added \"zastupitele.jmeno\" data")
        print(first_name)
        
        if self.metafile_data['zastupitele'].get('politickeSubjekty') is not None:
            if self.metafile_data['zastupitele']['politickeSubjekty'].get('data') is not None:
                political_subjects = self.metafile_data['zastupitele']['politickeSubjekty']['data']
                political_subjects = self.make_list_of_dicts_out_of_list_of_lists(political_subjects,'politickeSubjekty')
                first_name = self.combine_list_of_dicts(first_name,political_subjects)
        
        self.output_data['zastupitele'] = first_name
        print("INFO: Finished parsing of \"zastupitele\" data")
        print(self.output_data['zastupitele'])
        print("\n")
        return




    def get_votings_data(self):
        self.output_data['zasedani'] = {}
        if self.metafile_data.get('zastupitelstva') is None:
            print(f"ERROR: missing specification for \"zastupitelstva\"")
            exit(1)
        #######zasedani-hlasovani-cislo
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani'].get('cislo') is None:
            print(f"WARNING: missing specification for \"zastupitelstva.zasedani.hlasovani.cislo\"")
            print("Data will be added afterwards")
        sitting_vote_number = None
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani'].get('cislo') is not None:
            if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo'].get('data') is not None:
                sitting_vote_number = self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo'].copy()
                sitting_vote_number = self.give_dicts_key(sitting_vote_number['data'],'cislo')
            else:
                sitting_vote_number = (self.get_data_in_tree(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo']['tree_position'],
                                                            'cislo',
                                                            self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo'].get('_type'),
                                                            self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo'].get('parameters'),
                                                            self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo'].get('_key_is_value'),
                                                            self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo'].get('_list_type')))
                if sitting_vote_number == []:
                    print("WARNING: Specification for attribute above is set, but returns empty list ( [] ). Check if the metamodel spec is correct!")        
        self.check_duplicate_sitting_voting_number(sitting_vote_number)
        print("INFO: Added \"zastupitelstva.zasedani.hlasovani.cislo\" data")
        print(sitting_vote_number)
        #######zastupitelstva-zasedani-hlasovani-cas
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani'].get('cas') is None:
            print(f"WARNING: missing specification for \"zastupitelstva.zasedani.hlasovani.cas\"")
        sitting_vote_time = None
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani'].get('cas') is not None:
            sitting_vote_time = self.get_data_in_tree(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas']['tree_position'],
                                                        'cas',
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas'].get('_type'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas'].get('parameters'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas'].get('_key_is_value'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas'].get('_list_type'))
            if sitting_vote_time == []:
                print("WARNING: Specification for attribute above is set, but returns empty list ( [] ). Check if the metamodel spec is correct!")        
            sitting_vote_number = self.combine_leaves_of_lists(sitting_vote_time,sitting_vote_number)
        print("INFO: Added \"zastupitelstva.zasedani.hlasovani.cas\" data")
        print(sitting_vote_number)
        #######zastupitelstva-zasedani-hlasovani-urlProtokol
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani'].get('urlProtokol') is None:
            print(f"WARNING: missing specification for \"zastupitelstva.zasedani.hlasovani.urlProtokol\"")
        sitting_vote_url_protocol = None
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani'].get('urlProtokol') is not None:
            sitting_vote_url_protocol = self.get_data_in_tree(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['urlProtokol']['tree_position'],
                                                        'urlProtokol',
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['urlProtokol'].get('_type'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['urlProtokol'].get('parameters'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['urlProtokol'].get('_key_is_value'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['urlProtokol'].get('_list_type'))
            if sitting_vote_url_protocol == []:
                print("WARNING: Specification for attribute above is set, but returns empty list ( [] ). Check if the metamodel spec is correct!")        
            sitting_vote_number = self.combine_leaves_of_lists(sitting_vote_url_protocol,sitting_vote_number)
        print("INFO: Added \"zastupitelstva.zasedani.hlasovani.urlProtokol\" data")
        print(sitting_vote_number)
        #######zastupitelstva-zasedani-hlasovani-prijato
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani'].get('prijato') is None:
            print(f"INFO: missing specification for \"zastupitelstva.zasedani.hlasovani.prijato\"")
        sitting_vote_approved = None
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani'].get('prijato') is not None:
            sitting_vote_approved = self.get_data_in_tree(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['prijato']['tree_position'],
                                                        'prijato',
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['prijato'].get('_type'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['prijato'].get('parameters'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['prijato'].get('_key_is_value'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['prijato'].get('_list_type'))
            if sitting_vote_approved == []:
                print("WARNING: Specification for attribute above is set, but returns empty list ( [] ). Check if the metamodel spec is correct!")        
            sitting_vote_number = self.combine_leaves_of_lists(sitting_vote_approved,sitting_vote_number)
        print("INFO: Added \"zastupitelstva.zasedani.hlasovani.prijato\" data")
        print(sitting_vote_number)
        #######zastupitelstva-zasedani-hlasovani-platne
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani'].get('platne') is None:
            print(f"INFO: missing specification for \"zastupitelstva.zasedani.hlasovani.platne\"")
        sitting_vote_approved = None
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani'].get('platne') is not None:
            sitting_vote_approved = self.get_data_in_tree(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['platne']['tree_position'],
                                                        'platne',
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['platne'].get('_type'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['platne'].get('parameters'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['platne'].get('_key_is_value'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['platne'].get('_list_type'))
            if sitting_vote_approved == []:
                print("WARNING: Specification for attribute above is set, but returns empty list ( [] ). Check if the metamodel spec is correct!")        
            sitting_vote_number = self.combine_leaves_of_lists(sitting_vote_approved,sitting_vote_number)
        print("INFO: Added \"zastupitelstva.zasedani.hlasovani.platne\" data")
        print(sitting_vote_number)




        #######zasedani-hlasovani-projednavano-predmetHlasovani
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0].get('predmetHlasovani') is None:
            print(f"ERROR: missing specification for \"zastupitelstva.zasedani.hlasovani.projednavano.predmetHlasovani\"")
            exit(1)
        sitting_subject = self.get_data_in_tree(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani']['tree_position'],
                                                'predmetHlasovani',
                                                self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani'].get('_type'),
                                                self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani'].get('parameters'),
                                                self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani'].get('_key_is_value'),
                                                self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani'].get('_list_type'))
        if sitting_subject == []:
            print("WARNING: Specification for attribute above is set, but returns empty list ( [] ). Check if the metamodel spec is correct!")        
        sitting_subject = self.wrap_leaves_into_list(sitting_subject,'projednavano')
        sitting_subject = self.combine_leaves_of_lists(sitting_subject,sitting_vote_number)
        print("INFO: Added \"zastupitelstva.zasedani.hlasovani.projednavano.predmetHlasovani\" data")
        print(sitting_subject)
        print("\n")

        #######zasedani-hlasovani-zastupiteleHlasy
        sitting_voting_deputy_id = []
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy'].get('idZastupitel') is None:
            print(f"WARNING: missing specification for \"zastupitelstva.zasedani.hlasovani.zastupiteleHlasy.idZastupitel\"")
            print("Data will be added afterwards")
        else:
            sitting_voting_deputy_id = self.get_data_in_tree(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel']['tree_position'],
                                                'idZastupitel',
                                                self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel'].get('_type'),
                                                self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel'].get('parameters'),
                                                self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel'].get('_key_is_value'),
                                                self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel'].get('_list_type'),
                                                self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel'].get('_make_list_one_dimension'))
            if sitting_voting_deputy_id == []:
                print("WARNING: Specification for attribute above is set, but returns empty list ( [] ). Check if the metamodel spec is correct!")        
            if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel'].get('_make_list_one_dimension') == True:
                sitting_voting_deputy_id = self.make_list_one_dimension(sitting_voting_deputy_id)
        print("INFO: Added \"zastupitelstva.zasedani.hlasovani.zastupiteleHlasy.idZastupitel\" data")
        print(sitting_voting_deputy_id)
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy'].get('hlas') is None:
            print(f"ERROR: missing specification for \"zastupitelstva.zasedani.hlasovani.zastupiteleHlasy.hlas\"")
            exit(1)
        sitting_voting_vote = self.get_data_in_tree(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas']['tree_position'],
                                               'hlas',
                                               self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas'].get('_type'),
                                               self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas'].get('parameters'),
                                               self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas'].get('_key_is_value'),
                                               self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas'].get('_list_type'),
                                               self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas'].get('_make_list_one_dimension'))#TODO c_make_list_one_dimension for all fnc calls
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas'].get('_make_list_one_dimension') == True:
                sitting_voting_vote = self.make_list_one_dimension(sitting_voting_vote)
        sitting_voting_vote = self.combine_leaves_of_lists(sitting_voting_deputy_id,sitting_voting_vote)

        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy'].get('prezencne') is None:
            print(f"WARNING: missing specification for \"zastupitelstva.zasedani.hlasovani.zastupiteleHlasy.prezencne\"")
        else:
            sitting_voting_in_person = self.get_data_in_tree(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['prezencne']['tree_position'],
                                               'prezencne',
                                               self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['prezencne'].get('_type'),
                                               self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['prezencne'].get('parameters'),
                                               self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['prezencne'].get('_key_is_value'),
                                               self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['prezencne'].get('_list_type'),
                                               self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['prezencne'].get('_make_list_one_dimension'))#TODO c_make_list_one_dimension for all fnc calls
            if sitting_voting_in_person == []:
                print("WARNING: Specification for attribute above is set, but returns empty list ( [] ). Check if the metamodel spec is correct!")        
            if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['prezencne'].get('_make_list_one_dimension') == True:
                    sitting_voting_in_person = self.make_list_one_dimension(sitting_voting_in_person)
            sitting_voting_vote = self.combine_leaves_of_lists(sitting_voting_in_person,sitting_voting_vote)
            print("INFO: Added \"zastupitelstva.zasedani.hlasovani.zastupiteleHlasy.prezencne\" data")

        
        sitting_voting_vote = self.assign_key_to_lowest_list(sitting_voting_vote,'zastupiteleHlasy')
        sitting_voting_vote = self.remove_extra_brackets(sitting_voting_vote)
        sitting_voting_vote = self.combine_leaves_of_lists(sitting_subject,sitting_voting_vote)
        print("INFO: Added \"zastupitelstva.zasedani.hlasovani.zastupiteleHlasy.hlas\" data")
        #######zasedani-cislo
        if self.metafile_data['zastupitelstva'][0]['zasedani'].get('cislo') is None:
            print(f"WARNING: missing specification for \"zastupitelstva.zasedani.cislo\"")
            print(f"Data will be added afterwards")
        
        sitting_number = None
        if self.metafile_data['zastupitelstva'][0]['zasedani'].get('cislo') is not None:
            if self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].get('data') is not None:
                sitting_number = self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].copy()
                sitting_number = self.give_dicts_key(sitting_number['data'],'cislo')
            else:
                sitting_number = (self.get_data_in_tree(self.metafile_data['zastupitelstva'][0]['zasedani']['cislo']['tree_position'],
                                                            'cislo',
                                                            self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].get('_type'),
                                                            self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].get('parameters'),
                                                            self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].get('_key_is_value'),
                                                            self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].get('_list_type')))
                if sitting_number == []:
                    print("WARNING: Specification for attribute above is set, but returns empty list ( [] ). Check if the metamodel spec is correct!")        
            #check duplicity of cislo value
            self.check_duplicate_sitting_number(sitting_number)
        print("INFO: Added \"zastupitelstva.zasedani.cislo\" data")
        print(sitting_number)
        #######zasedani-datum
        if self.metafile_data['zastupitelstva'][0]['zasedani'].get('datum') is None:
            print(f"ERROR: missing specification for \"zastupitelstva.zasedani.datum\"")
            exit(1)
        sitting_date = (self.get_data_in_tree(self.metafile_data['zastupitelstva'][0]['zasedani']['datum']['tree_position'],
                                             'datum',
                                             self.metafile_data['zastupitelstva'][0]['zasedani']['datum'].get('_type'),
                                             self.metafile_data['zastupitelstva'][0]['zasedani']['datum'].get('parameters'),
                                             self.metafile_data['zastupitelstva'][0]['zasedani']['datum'].get('_key_is_value'),
                                             self.metafile_data['zastupitelstva'][0]['zasedani']['datum'].get('_list_type')))
        if sitting_date == []:
            print("WARNING: Specification for attribute above is set, but returns empty list ( [] ). Check if the metamodel spec is correct!")        
        if self.metafile_data['zastupitelstva'][0]['zasedani'].get('cislo') is not None:
            sitting_date = self.combine_leaves_of_lists(sitting_date,sitting_number)

        #if there is only one sitting, we have to give hlasovani key to the whole list
        if isinstance(sitting_date,dict):
            sitting_voting_vote = self.make_list_of_dicts_out_of_list_of_lists(sitting_voting_vote,'hlasovani',True)
        else:
            sitting_voting_vote = self.make_list_of_dicts_out_of_list_of_lists(sitting_voting_vote,'hlasovani',False)
        sitting_date = self.combine_list_of_dicts(sitting_date, sitting_voting_vote)
        print("INFO: Added \"zastupitelstva.zasedani.datum\" data")
        print(sitting_date)
        #all concatenated parts assigned to new variable
        #new variable name makes more sense in context
        all_sitting = sitting_date

        council_list = []
        if self.metafile_data['zastupitelstva'][0].get('poradiZastupitelstva') is None:
            print(f"ERROR: missing specification for \"zastupitelstva.poradiZastupitelstva\"")
            exit(1)
        if self.metafile_data['zastupitelstva'][0].get('od') is None:
            print(f"ERROR: missing specification for \"zastupitelstva.od\"")
            exit(1)
        if self.metafile_data['zastupitelstva'][0].get('do') is None:
            print(f"ERROR: missing specification for \"zastupitelstva.do\"")
            exit(1)
        for council in self.metafile_data['zastupitelstva']:
            council_order = []
            #poradiZastupitelstva
            
            if council['poradiZastupitelstva'].get('data') is not None:
                council_order = council['poradiZastupitelstva'].copy()
                self.change_dict_key_name(council_order,'poradiZastupitelstva','data')

            if council['od'].get('data') is not None:
                council_from = council['od'].copy()
                self.change_dict_key_name(council_from,'od','data')
            council_order = self.combine_dicts(council_order,council_from)

            if council['do'].get('data') is not None:
                council_to = council['do'].copy()
                self.change_dict_key_name(council_to,'do','data')
            council_order = self.combine_dicts(council_order,council_to)


            #lidr        
            leader_list = []
            for leader in council['lidr']:
                if leader.get('idZastupitel') is None:
                    print(f"ERROR: missing specification for \"zastupitelstva.lidr.idZastupitel\"")
                    return
                if leader.get('funkce') is None:
                    print(f"ERROR: missing specification for \"zastupitelstva.lidr.funkce\"")
                    return
                if leader.get('od') is None:
                    print(f"ERROR: missing specification for \"zastupitelstva.lidr.od\"")
                    return
                if leader.get('do') is None:
                    print(f"ERROR: missing specification for \"zastupitelstva.lidr.do\"")
                    return
                if leader['idZastupitel'].get('data') is not None:
                    leader_id = leader['idZastupitel'].copy()
                    self.change_dict_key_name(leader_id,'idZastupitel','data')
                if leader['funkce'].get('data') is not None:
                    leader_func = leader['funkce'].copy()
                    self.change_dict_key_name(leader_func,'funkce','data')
                leader_id = self.combine_dicts(leader_id,leader_func)
                if leader['od'].get('data') is not None:
                    leader_from = leader['od'].copy()
                    self.change_dict_key_name(leader_from,'od','data')
                else:
                    leader_from = self.get_data_in_tree(leader['od']['tree_position'],
                                                                            'od',
                                                                            leader['od'].get('_type'),
                                                                            leader['od'].get('parameters'),
                                                                            leader['od'].get('_key_is_value'),
                                                                            leader['od'].get('_list_type'))
                leader_id = self.combine_dicts(leader_id,leader_from)
                if leader['do'].get('data') is not None:
                    leader_to = leader['do'].copy()
                    self.change_dict_key_name(leader_to,'do','data')
                else:
                    leader_to = self.get_data_in_tree(leader['do']['tree_position'],
                                                      'do',
                                                      leader['do'].get('_type'),
                                                      leader['do'].get('parameters'),
                                                      leader['do'].get('_key_is_value'),
                                                      leader['do'].get('_list_type'))
                leader_id = self.combine_dicts(leader_id,leader_to)
                leader_list.append(leader_id)
            leader_dict = {'lidr':leader_list}
            council_order = self.combine_dicts(council_order,leader_dict)
        

            #coalition
            coalition_list = []
            for coalition in council['koalice']:
                if coalition.get('idPolitickeSubjekty') is None:
                    print(f"ERROR: missing specification for \"zastupitelstva.koalice.idZastupitel\"")
                    return
                if coalition.get('od') is None:
                    print(f"ERROR: missing specification for \"zastupitelstva.koalice.od\"")
                    return
                if coalition.get('do') is None:
                    print(f"ERROR: missing specification for \"zastupitelstva.koalice.do\"")
                    return
                
                if coalition['idPolitickeSubjekty'].get('data') is not None:
                    coalition_ids = coalition['idPolitickeSubjekty'].copy()
                    self.change_dict_key_name(coalition_ids,'idPolitickeSubjekty','data')
                if coalition['od'].get('data') is not None:
                    coalition_from = coalition['od'].copy()
                    self.change_dict_key_name(coalition_from,'od','data')
                else:
                    coalition_from = self.get_data_in_tree(coalition['od']['tree_position'],'od',
                                                           coalition['od'].get('_type'),
                                                           coalition['od'].get('parameters'),
                                                           coalition['od'].get('_key_is_value'),
                                                           coalition['od'].get('_list_type'))
                coalition_ids = self.combine_dicts(coalition_ids,coalition_from)
                if coalition['do'].get('data') is not None:
                    coalition_to = coalition['do'].copy()
                    self.change_dict_key_name(coalition_to,'do','data')
                else:
                    coalition_to = self.get_data_in_tree(coalition['do']['tree_position'],
                                                         'do',
                                                         coalition['do'].get('_type'),
                                                         coalition['do'].get('parameters'),
                                                         coalition['do'].get('_key_is_value'),
                                                         coalition['do'].get('_list_type'))
                coalition_ids = self.combine_dicts(coalition_ids,coalition_to)
                coalition_list.append(coalition_ids)
            coalition_dict = {'koalice':coalition_list}

        
            council_order = self.combine_dicts(council_order,coalition_dict)
            
            council_list.append(council_order)
        print("INFO: Added \"zastupitelstva.koalice\" and \"zastupitelstva.lidr\" data")
        council_list[0]['zasedani'] = all_sitting
        #combining zasedani and other values on this level
        self.output_data['zastupitelstva'] = []
        # one element has to be appended to prevent error
        if not self.output_data['zastupitelstva']:
            self.output_data['zastupitelstva'].append({})
        self.output_data['zastupitelstva'][0] = council_list[0]
        self.output_data['zastupitelstva'][1:] = [item for item in council_list[1:]]
        del self.output_data['zasedani']
        print("INFO: Finished parsing of \"zastupitelstva\" data")
        print(self.output_data)
        print("\n")
        return

    
