import sys
from datetime import datetime
from src.Creator.ConcreteCreator import ConcreteCreator
from .CommonParser import CommonParser


class TableFileParser(CommonParser):
    """
    Class for parsing csv
    """
    def __init__(self, metafile,one_file=False,filename="",by_sittings_or_more = False):
        super().__init__(metafile,one_file,filename,by_sittings_or_more)


    def parse_file(self,data):
        """
        Parse csv input file

        Parameters:
            data: data to be parsed
        """
        self.data = data
        #TODO hotfix - fix circularity
        from src.Cleaning.Data_clean import DataClean
        data_clean = DataClean(self.data,self.metafile_data)
        self.data = data_clean.clean_data()
        self.get_municipality()
        self.get_political_subjects()
        self.get_deputies_data()
        self.get_votings_data()
        self.count_result_of_all_votings()
        self.get_validity_of_all_votings()
        self.give_voting_number_to_all_votings()
        self.give_ids(self.output_data['politickeSubjekty'],'id')
        self.give_ids(self.output_data['zastupitele'],'id')

        self.give_party_ids_to_deputies_by_name()
        
        self.assign_ids_to_deputies_votes()
        self.delete_one_of()
        return self.output_data

    def get_data_of_position(self, start_x, end_x, start_y, end_y, key, by_column=False, value_type=None,value_params=None):
        """
        Method for reading data from csv grid and returning it as a list of dictionaries

        Parameters:
        start_x: column of grid where to start
        end_x: column of grid where to end, if to the end of the grid then "end" string can be used
        start_y: row of grid where to start
        end_y: row of grid where to end, if to the end of the grid then "end" string can be used
        key(str): name of the key values will be assigned to in dictionary
        by_column(bool): which direction to make lists from
        """
        # by column is not set set it to False
        if by_column is None:
            by_column = False

        # check if end values are integers otherwise make them large number to simulate iterating to the end of the row
        if not isinstance(end_y, int):
            end_y = sys.maxsize
        if not isinstance(end_x, int):
            end_x = sys.maxsize

        #for python like behaviour with minus index values
        if end_y < 0:
            start_y = len(self.data) + start_y
        if end_y < 0:
            end_y = len(self.data) + end_y

        output_list = []
        temp_list = []

        for i, row in enumerate(self.data):
            if start_y <= i <= end_y:
                if start_x < 0:
                    start_x = len(row) + start_x
                if end_x < 0:
                    end_x = len(row) + end_x
                for j, value in enumerate(row):
                    if start_x <= j <= end_x:
                        #if lists made by columns
                        if by_column:
                            #if first element in column array
                            if len(temp_list) <= (j - start_x):
                                if value_type is None:
                                    temp_list.append([{key: value}])
                                else:
                                    creator = ConcreteCreator()
                                    temp_list.append([{key: creator.get_value_by_type(value,value_type,value_params,self.user_fnc_file,self.filename)}])
                            #not the first element in column array
                            else:
                                if value_type is None:
                                    temp_list[j - start_x].append({key: value})
                                else:
                                    creator = ConcreteCreator()
                                    temp_list[j - start_x].append({key: creator.get_value_by_type(value,value_type,value_params,self.user_fnc_file,self.filename)})
                        else:
                            if value_type is None:
                                temp_list.append({key: value})
                            else:
                                creator = ConcreteCreator()
                                temp_list.append({key: creator.get_value_by_type(value,value_type,value_params,self.user_fnc_file,self.filename)})
                if not by_column:
                    output_list.append(temp_list)
                    temp_list = []

        if by_column:
            output_list = temp_list

        return output_list
    
    def get_municipality(self):
        """
        Method for getting info about municipalities
        """
        if self.metafile_data['municipalita'].get('data') is not None:
            self.output_data['municipalita'] = self.metafile_data['municipalita']['data']
        print("INFO: Finished parsing \"municipalita.data\"")
    
    def get_political_subjects(self):
        """
        Method for getting info about politicalsubjects
        """
        if self.metafile_data['politickeSubjekty'].get('data') is not None:
            self.output_data['politickeSubjekty'] = self.metafile_data['politickeSubjekty']['data']
            print("INFO: Added \"politickeSubjekty\" data")
        else:
            parties = []
            colour = []
            if self.metafile_data['politickeSubjekty']['zkrNazev'].get('data') is not None:
                parties = self.metafile_data['politickeSubjekty']['zkrNazev']['data']
                parties = self.metafile_data['politickeSubjekty']['zkrNazev'].copy()
                parties = self.give_dicts_key(parties['data'],'zkrNazev')
            else:
                parties = self.flatten_output(self.get_data_of_position(self.metafile_data['politickeSubjekty']['zkrNazev']['start_x'],
                                                   self.metafile_data['politickeSubjekty']['zkrNazev']['end_x'],
                                                   self.metafile_data['politickeSubjekty']['zkrNazev']['start_y'],
                                                   self.metafile_data['politickeSubjekty']['zkrNazev']['end_y'],
                                                   'zkrNazev',
                                                   self.metafile_data['politickeSubjekty']['zkrNazev'].get('_by_column'),
                                                   self.metafile_data['politickeSubjekty']['zkrNazev'].get('_type'),
                                                   self.metafile_data['politickeSubjekty']['zkrNazev'].get('parameters')))
                parties = self.remove_duplicates_in_list_of_dicts(parties)
                parties = self.apply_list_type_rule_on_list(parties,'zkrNazev',self.metafile_data['politickeSubjekty']['zkrNazev'].get('_list_type'))
            print("INFO: Added \"politickeSubjekty.zkrNazev\" data")
            if self.metafile_data['politickeSubjekty']['barva'].get('data') is not None:
                colour = self.metafile_data['politickeSubjekty']['barva']['data']
                colour = self.metafile_data['politickeSubjekty']['barva'].copy()
                colour = self.give_dicts_key(colour['data'],'barva')
            else:
                colour = self.flatten_output(self.get_data_of_position(self.metafile_data['politickeSubjekty']['barva']['start_x'],
                                                   self.metafile_data['politickeSubjekty']['barva']['end_x'],
                                                   self.metafile_data['politickeSubjekty']['barva']['start_y'],
                                                   self.metafile_data['politickeSubjekty']['barva']['end_y'],
                                                   'barva',
                                                   self.metafile_data['politickeSubjekty']['barva'].get('_by_column'),
                                                   self.metafile_data['politickeSubjekty']['barva'].get('_type'),
                                                   self.metafile_data['politickeSubjekty']['barva'].get('parameters')))
                colour = self.apply_list_type_rule_on_list(colour,'barva',self.metafile_data['politickeSubjekty']['barva'].get('_list_type'))
            print("INFO: Added \"politickeSubjekty.barva\" data")
            self.output_data['politickeSubjekty'] = self.combine_list_of_dicts(colour,parties)
            
    

    def get_deputies_data(self):
        """
        Get info about "zastupitele", build it like defined in the model
        """

        #if all info is written in metafile return immediately
        if self.metafile_data['zastupitele'].get('data') is not None:
            self.output_data['zastupitele'] = self.metafile_data['zastupitele']['data']
            print("INFO: Added \"zastupitele\" data")
            return


        # last name
        if self.metafile_data['zastupitele'].get('prijmeni') is None:
            print(f"ERROR: missing specification for \"zastupitele.prijmeni\"")
            exit(1)

        if self.metafile_data['zastupitele']['prijmeni'].get('data') is not None:
            last_name = self.metafile_data['zastupitele']['prijmeni']['data']
            last_name = self.metafile_data['zastupitele']['prijmeni'].copy()
            last_name = self.give_dicts_key(last_name['data'],'prijmeni')
        else:
            last_name = self.flatten_output(self.get_data_of_position(self.metafile_data['zastupitele']['prijmeni']['start_x'],
                                                                    self.metafile_data['zastupitele']['prijmeni']['end_x'],
                                                                    self.metafile_data['zastupitele']['prijmeni']['start_y'],
                                                                    self.metafile_data['zastupitele']['prijmeni']['end_y'],
                                                                    'prijmeni',
                                                                    self.metafile_data['zastupitele']['prijmeni'].get('_by_column'),
                                                                    self.metafile_data['zastupitele']['prijmeni'].get('_type'),
                                                                    self.metafile_data['zastupitele']['prijmeni'].get('parameters')))
            last_name = self.apply_list_type_rule_on_list(last_name,'prijmeni',self.metafile_data['zastupitele']['prijmeni'].get('_list_type'))
        print("INFO: Added \"zastupitele.prijmeni\" data")

        # first name
        if self.metafile_data['zastupitele'].get('jmeno') is None:
            print(f"ERROR: missing specification for \"zastupitele.jmeno\"")
            exit(1) 
        if self.metafile_data['zastupitele']['jmeno'].get('data') is not None:
            first_name = self.metafile_data['zastupitele']['jmeno']['data']
            first_name = self.metafile_data['zastupitele']['jmeno'].copy()
            first_name = self.give_dicts_key(first_name['data'],'jmeno')
        else:
            first_name = self.flatten_output(self.get_data_of_position(self.metafile_data['zastupitele']['jmeno']['start_x'],
                                                                    self.metafile_data['zastupitele']['jmeno']['end_x'],
                                                                    self.metafile_data['zastupitele']['jmeno']['start_y'],
                                                                    self.metafile_data['zastupitele']['jmeno']['end_y'],
                                                                    'jmeno',
                                                                    self.metafile_data['zastupitele']['jmeno'].get('_by_column'),
                                                                    self.metafile_data['zastupitele']['jmeno'].get('_type'),
                                                                    self.metafile_data['zastupitele']['jmeno'].get('parameters')))
            first_name = self.apply_list_type_rule_on_list(first_name,'jmeno',self.metafile_data['zastupitele']['jmeno'].get('_list_type'))
        print("INFO: Added \"zastupitele.jmeno\" data")

        person_list = []
        if self.metafile_data['zastupitele'].get('politickeSubjekty') is None:
            print(f"ERROR: missing specification for \"zastupitele.polickeSubjekty\"")
            exit(1)
        if len(self.metafile_data['zastupitele']['politickeSubjekty']) == 1:
            if self.metafile_data['zastupitele']['politickeSubjekty'][0]['idPolitickySubjekt'].get('data') is not None:
                person_party_id = self.get_data_of_position(self.metafile_data['zastupitele']['politickeSubjekty'][0]['idPolitickySubjekt']['data'])
            else:
                person_party_id = self.flatten_output(self.get_data_of_position(self.metafile_data['zastupitele']['politickeSubjekty'][0]['idPolitickySubjekt']['start_x'],
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['idPolitickySubjekt']['end_x'],
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['idPolitickySubjekt']['start_y'],
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['idPolitickySubjekt']['end_y'],
                                                                        'idPolitickySubjekt',
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['idPolitickySubjekt'].get('_by_column'),
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['idPolitickySubjekt'].get('_type'),
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['idPolitickySubjekt'].get('parameters')))
                person_party_id = self.apply_list_type_rule_on_list(person_party_id,'idPolitickySubjekt',self.metafile_data['zastupitele']['politickeSubjekty'][0]['idPolitickySubjekt'].get('_list_type'))
                
            if self.metafile_data['zastupitele']['politickeSubjekty'][0]['od'].get('data') is not None:
                person_from = self.get_data_of_position(self.metafile_data['zastupitele']['politickeSubjekty'][0]['od']['data'])
            else:
                person_from = self.flatten_output(self.get_data_of_position(self.metafile_data['zastupitele']['politickeSubjekty'][0]['od']['start_x'],
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['od']['end_x'],
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['od']['start_y'],
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['od']['end_y'],
                                                                        'od',
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['od'].get('_by_column'),
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['od'].get('_type'),
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['od'].get('parameters')))
                person_from = self.apply_list_type_rule_on_list(person_from,'od',self.metafile_data['zastupitele']['politickeSubjekty'][0]['od'].get('_list_type'))
            person_party_id = self.combine_list_of_dicts(person_from,person_party_id)

            if self.metafile_data['zastupitele']['politickeSubjekty'][0]['do'].get('data') is not None:
                person_to = self.get_data_of_position(self.metafile_data['zastupitele']['politickeSubjekty'][0]['do']['data'])
            else:
                person_to = self.flatten_output(self.get_data_of_position(self.metafile_data['zastupitele']['politickeSubjekty'][0]['do']['start_x'],
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['do']['end_x'],
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['do']['start_y'],
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['do']['end_y'],
                                                                        'do',
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['do'].get('_by_column'),
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['do'].get('_type'),
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['do'].get('parameters')))
                person_to = self.apply_list_type_rule_on_list(person_to,'do',self.metafile_data['zastupitele']['politickeSubjekty'][0]['do'].get('_list_type'))
            person_party_id = self.combine_list_of_dicts(person_to,person_party_id)    

            if self.metafile_data['zastupitele']['politickeSubjekty'][0]['poradiZastupitelstva'].get('data') is not None:
                person_party_council_order = self.metafile_data['zastupitele']['politickeSubjekty'][0]['poradiZastupitelstva']['data']
                person_party_council_order = self.metafile_data['zastupitele']['politickeSubjekty'][0]['poradiZastupitelstva'].copy()
                person_party_council_order = self.give_dicts_key(person_party_council_order['data'],'poradiZastupitelstva')
            else:
                person_party_council_order = self.flatten_output(self.get_data_of_position(self.metafile_data['zastupitele']['politickeSubjekty'][0]['poradiZastupitelstva']['start_x'],
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['poradiZastupitelstva']['end_x'],
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['poradiZastupitelstva']['start_y'],
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['poradiZastupitelstva']['end_y'],
                                                                        'poradiZastupitelstva',
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['poradiZastupitelstva'].get('_by_column'),
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['poradiZastupitelstva'].get('_type'),
                                                                        self.metafile_data['zastupitele']['politickeSubjekty'][0]['poradiZastupitelstva'].get('parameters')))
                person_party_council_order = self.apply_list_type_rule_on_list(person_party_council_order,'poradiZastupitelstva',self.metafile_data['zastupitele']['politickeSubjekty'][0]['poradiZastupitelstva'].get('_list_type'))
            person_party_id = self.combine_list_of_dicts(person_party_id,person_party_council_order)
            person_list = []
            person_list = self.wrap_list_of_dicts_into_list_of_lists(person_party_id,'politickeSubjekty')



        else:
            for person in self.metafile_data['zastupitele']['politickeSubjekty']:
                if person['idPolitickySubjekt'].get('data') is not None:
                    person_party_id = person['idPolitickySubjekt']
                    self.change_dict_key_name(person_party_id,'idPolitickySubjekt','data')
                if person['poradiZastupitelstva'].get('data') is not None:
                    person_municipality_order = person['poradiZastupitelstva']
                    self.change_dict_key_name(person_municipality_order,'poradiZastupitelstva','data')
                person_party_id = self.combine_dicts(person_party_id,person_municipality_order)
                if person['od'].get('data') is not None:
                    person_from = person_from['od']
                    self.change_dict_key_name(person_from,'od','data')
                else:
                    person_from = self.flatten_output(self.get_data_of_position(person['od']['start_x'],
                                                    person['od']['end_x'],
                                                    person['od']['start_y'],
                                                    person['od']['end_y'],
                                                    'od',
                                                    (person['od']['end_x']-person['od']['start_x']),
                                                    person['od'].get('_type'),
                                                    person['od'].get('parameters')))
                    person_from = self.apply_list_type_rule_on_list(person_from,'od',person['od'].get('_list_type'))
                person_party_id = self.combine_dicts(person_party_id,person_from)
                if person['do'].get('data') is not None:
                    person_to = person['do']
                    self.change_dict_key_name(person_to,'do','data')
                else:
                    person_to = self.flatten_output(self.get_data_of_position(person['do']['start_x'],
                                                    person['do']['end_x'],
                                                    person['do']['start_y'],
                                                    person['do']['end_y'],
                                                    'do',
                                                    (person['do']['end_x']-person['do']['start_x']),
                                                    person['do'].get('_type'),
                                                    person['do'].get('parameters')))
                    person_to = self.apply_list_type_rule_on_list(person_to,'do',person['do'].get('_list_type'))
                person_party_id = self.combine_dicts(person_party_id,person_to)
                person_list.append({'politickeSubjekty':[person_party_id]})
        print("INFO: Added \"zastupitele.politickeSubjekty\" data")

        last_name = self.combine_list_of_dicts(last_name,first_name)
        


        self.output_data['zastupitele'] = self.combine_list_of_dicts(last_name,person_list)
        print(f"INFO: Finished parsing of \"zastupitele\" data")
        
            
    def get_votings_data(self):
        """
        Get info about votings, build it like defined in the model
        """
        self.output_data['zasedani'] = {}
        #######zasedani-hlasovani-cislo
        if self.metafile_data.get('zastupitelstva') is None:
            print(f"ERROR: missing specification for \"zastupitelstva\"")
            exit(1) 
        

        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani'].get('cislo') is None:
            print(f"WARNING: missing specification for \"zastupitelstvo.zasedani.hlasovani.cislo\"")
            print("Data will be added afterwards") 
        sitting_vote_number = self.get_data_of_position(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo']['start_x'],
                                                                          self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo']['end_x'],
                                                                          self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo']['start_y'],
                                                                          self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo']['end_y'],
                                                                          'cislo',
                                                                          (self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo'].get('_by_column')))
        self.output_data['cislo'] = self.flatten_output(sitting_vote_number)
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo'].get('_split_number') is not None:
            self.output_data['cislo'] = self.flatten_output(self.split_list_into_sublist_by_number(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo'].get('_split_number'),
                                                                 self.output_data['cislo'],
                                                                 self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo'].get('_delete_all_values_except_one')))
        #check duplicity of cislo value
        self.check_duplicate_sitting_number(self.output_data['cislo'])
        self.output_data['cislo'] = self.apply_list_type_rule_on_list(self.output_data['cislo'],'cislo',self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cislo'].get('_list_type'))
        print(f"INFO: Added \"zastupitelstvo.zasedani.hlasovani.cislo\" data")
        ######
        #######zastupitelstva-zasedani-hlasovani-cas
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani'].get('cas') is None:
            print(f"WARNING: missing specification for \"zastupitelstvo.zasedani.hlasovani.cas\"")
        sitting_vote_time = self.get_data_of_position(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas']['start_x'],
                                                      self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas']['end_x'],
                                                      self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas']['start_y'],
                                                      self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas']['end_y'],
                                                      'cas',
                                                      (self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas'].get('_by_column')),
                                                      self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas'].get('_type'),
                                                      self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas'].get('parameters'))
        sitting_vote_time = self.flatten_output(sitting_vote_time)
        sitting_vote_time = self.apply_list_type_rule_on_list(sitting_vote_time,'cas',self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas'].get('_list_type'))
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['cas'].get('_split_number') is not None:
            sitting_vote_time = self.flatten_output(self.split_list_into_sublist_by_number(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani'].get('_split_number'),
                                                                 sitting_vote_time,
                                                                 self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani'].get('_delete_all_values_except_one')))
        sitting_vote_time_number = self.combine_list_of_dicts(sitting_vote_time,self.output_data['cislo'])
        print("INFO: Added \"zastupitelstvo.zasedani.hlasovani.cas\" data")
        #######zastupitelstva-zasedani-datum
        if self.metafile_data['zastupitelstva'][0]['zasedani'].get('datum') is None:
            print(f"ERROR: missing specification for \"zastupitelstvo.zasedani.datum\"")
            exit(1) 
        sitting_date = self.get_data_of_position(self.metafile_data['zastupitelstva'][0]['zasedani']['datum']['start_x'],
                                                 self.metafile_data['zastupitelstva'][0]['zasedani']['datum']['end_x'],
                                                 self.metafile_data['zastupitelstva'][0]['zasedani']['datum']['start_y'],
                                                 self.metafile_data['zastupitelstva'][0]['zasedani']['datum']['end_y'],
                                                 'datum',
                                                 (self.metafile_data['zastupitelstva'][0]['zasedani']['datum'].get('_by_column')),
                                                 self.metafile_data['zastupitelstva'][0]['zasedani']['datum'].get('_type'),
                                                 self.metafile_data['zastupitelstva'][0]['zasedani']['datum'].get('parameters'))
        sitting_date = self.flatten_output(sitting_date)
        sitting_date = self.apply_list_type_rule_on_list(sitting_date,'datum',self.metafile_data['zastupitelstva'][0]['zasedani']['datum'].get('_list_type'))
        if self.metafile_data['zastupitelstva'][0]['zasedani']['datum'].get('_split_number') is not None:
            sitting_date = self.flatten_output(self.split_list_into_sublist_by_number(self.metafile_data['zastupitelstva'][0]['zasedani']['datum'].get('_split_number'),
                                                                 sitting_date,
                                                                 self.metafile_data['zastupitelstva'][0]['zasedani']['datum'].get('_delete_all_values_except_one')))
        sitting_vote_time_number = self.combine_list_of_dicts(sitting_date,sitting_vote_time_number)
        print("INFO: Added \"zastupitelstva.zasedani.datum\" data")

        

        #######zasedani-hlasovani-projednavano-predmetHlasovani
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0].get('predmetHlasovani') is None:
            print(f"ERROR: missing specification for \"zastupitelstvo.zasedani.hlasovani.projednavano.predmetHlasovani\"")
            exit(1) 
        sitting_subject = self.get_data_of_position(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani']['start_x'],
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani']['end_x'],
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani']['start_y'],
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani']['end_y'],
                                                    'predmetHlasovani',
                                                    (self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani'].get('_by_column')),
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani'].get('_type'),
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani'].get('parameters'))
        sitting_subject = self.flatten_output(sitting_subject)
        sitting_subject = self.apply_list_type_rule_on_list(sitting_subject,'predmetHlasovani',self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani'].get('_list_type'))
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani'].get('_split_number') is not None:
            sitting_subject = self.flatten_output(self.split_list_into_sublist_by_number(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani'].get('_split_number'),
                                                                 sitting_subject,
                                                                 self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['projednavano'][0]['predmetHlasovani'].get('_delete_all_values_except_one')))
        self.output_data['zasedani']['hlasovani'] = self.wrap_list_of_dicts_into_list_of_lists(sitting_subject,'projednavano')
        

        self.output_data['zasedani']['hlasovani'] = self.combine_list_of_dicts(sitting_vote_time_number,self.output_data['zasedani']['hlasovani'])
        print("INFO: Added \"zastupitelstvo.zasedani.hlasovani.projednavano.predmetHlasovani\"")
        del self.output_data['cislo']
        

        #######zasedani-hlasovani-zastupiteleHlasy
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani'].get('zastupiteleHlasy') is None:
            print(f"ERROR: missing specification for \"zastupitelstvo.zasedani.hlasovani.zastupiteleHlasy\"")
            exit(1) 
        sitting_voting = self.get_data_of_position(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas']['start_x'],
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas']['end_x'],
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas']['start_y'],
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas']['end_y'],
                                                    'hlas',
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas'].get('_by_column'),
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas'].get('_type'),
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas'].get('parameters'))
        self.output_data['zastupiteleHlasy'] = self.flatten_output(sitting_voting)
        self.output_data['zastupiteleHlasy'] = self.apply_list_type_rule_on_list(self.output_data['zastupiteleHlasy'],'hlas',self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas'].get('_list_type'))
        self.output_data['zastupiteleHlasy'] = self.split_list_into_sublist_by_number(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas'].get('_split_number'),
                                                                                      self.output_data['zastupiteleHlasy'],
                                                                                      self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['hlas'].get('_delete_all_values_except_one'))
        self.output_data['zastupiteleHlasy'] = self.make_list_of_dicts_out_of_list_of_lists(self.output_data['zastupiteleHlasy'],'zastupiteleHlasy')
        print("INFO: Added \"zastupitelstvo.zasedani.hlasovani.zastupiteleHlasy\" data")

        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy'].get('idZastupitel') is not None:
            sitting_id_deputy = self.get_data_of_position(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel']['start_x'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel']['end_x'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel']['start_y'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel']['end_y'],
                                                        'idZastupitel',
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel'].get('_by_column'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel'].get('_type'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel'].get('parameters'))
            sitting_id_deputy = self.flatten_output(sitting_id_deputy)
            sitting_id_deputy = self.apply_list_type_rule_on_list(sitting_id_deputy,'idZastupitel',self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel'].get('_list_type'))
            new_list = []
            for i in range(0, len(sitting_id_deputy), 2):
                new_list.append(self.concateneate_list_of_dicts_same_key(sitting_id_deputy[i],sitting_id_deputy[i+1],'idZastupitel'))
            sitting_id_deputy = self.flatten_output(new_list)
            if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel'].get('_split_number') is not None:
                sitting_id_deputy = self.flatten_output(self.split_list_into_sublist_by_number(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel'].get('_split_number'),
                                                        sitting_id_deputy,
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['zastupiteleHlasy']['idZastupitel'].get('_delete_all_values_except_one')))
            sitting_id_deputy = self.make_list_of_dicts_out_of_list_of_lists(sitting_id_deputy,'zastupiteleHlasy')

            combined_list = []

            for dict1, dict2 in zip(sitting_id_deputy,self.output_data['zastupiteleHlasy']):
                combined_dict = {'zastupiteleHlasy': []}
                for entry1, entry2 in zip(dict1['zastupiteleHlasy'], dict2['zastupiteleHlasy']):
                    combined_entry = {'idZastupitel': entry1['idZastupitel'], 'hlas': entry2['hlas']}
                    combined_dict['zastupiteleHlasy'].append(combined_entry)
                combined_list.append(combined_dict)
            self.output_data['zastupiteleHlasy'] = combined_list
            print("INFO: Added \"zastupitelstva.zasedani.hlasovani.zastupiteleHlasy.idZastupitel\"")
            


        self.output_data['zasedani']['hlasovani'] = self.combine_list_of_dicts(self.output_data['zasedani']['hlasovani'],self.output_data['zastupiteleHlasy'])
        del self.output_data['zastupiteleHlasy']
        
        #######zasedani-hlasovani-sumarizace-A
        if self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace'] is not None:
            self.output_data['sumarizace'] = {}
            sitting_votes_summary_for = self.get_data_of_position(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['A']['start_x'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['A']['end_x'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['A']['start_y'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['A']['end_y'],
                                                        'A',
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['A'].get('_by_column'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['A'].get('_type'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['A'].get('parameters'))
            self.output_data['sumarizace']['A'] = self.flatten_output(sitting_votes_summary_for)
            self.output_data['sumarizace']['A'] = self.apply_list_type_rule_on_list(self.output_data['sumarizace']['A'],'A',self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['A'].get('_list_type'))

            #######zasedani-hlasovani-sumarizace-N
            sitting_votes_summary_against = self.get_data_of_position(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['N']['start_x'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['N']['end_x'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['N']['start_y'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['N']['end_y'],
                                                        'N',
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['N'].get('_by_column'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['N'].get('_type'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['N'].get('parameters'))
            self.output_data['sumarizace']['N'] = self.flatten_output(sitting_votes_summary_against)
            self.output_data['sumarizace']['N'] = self.apply_list_type_rule_on_list(self.output_data['sumarizace']['N'],'N',self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['N'].get('_list_type'))

            
            self.output_data['sumarizace']['N'] = self.combine_list_of_dicts(self.output_data['sumarizace']['A'],self.output_data['sumarizace']['N'])


            #######zasedani-hlasovani-sumarizace-X
            sitting_votes_summary_not_voting = self.get_data_of_position(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['X']['start_x'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['X']['end_x'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['X']['start_y'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['X']['end_y'],
                                                        'X',
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['X'].get('_by_column'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['X'].get('_type'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['X'].get('parameters'))
            self.output_data['sumarizace']['X'] = self.flatten_output(sitting_votes_summary_not_voting)
            self.output_data['sumarizace']['X'] = self.apply_list_type_rule_on_list(self.output_data['sumarizace']['X'],'X',self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['X'].get('_list_type'))

            
            self.output_data['sumarizace']['N'] = self.combine_list_of_dicts(self.output_data['sumarizace']['X'],self.output_data['sumarizace']['N'])

            #######zasedani-hlasovani-sumarizace-Z
            sitting_votes_summary_abstain = self.get_data_of_position(self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['Z']['start_x'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['Z']['end_x'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['Z']['start_y'],
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['Z']['end_y'],
                                                        'Z',
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['Z'].get('_by_column'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['Z'].get('_type'),
                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['Z'].get('parameters'))
            self.output_data['sumarizace']['Z'] = self.flatten_output(sitting_votes_summary_abstain)
            self.output_data['sumarizace']['Z'] = self.apply_list_type_rule_on_list(self.output_data['sumarizace']['Z'],'Z',self.metafile_data['zastupitelstva'][0]['zasedani']['hlasovani']['sumarizace']['Z'].get('_list_type'))
            self.output_data['sumarizace']['Z'] = self.combine_list_of_dicts(self.output_data['sumarizace']['N'],self.output_data['sumarizace']['Z'])
            self.output_data['sumarizace'] = self.give_dicts_key(self.output_data['sumarizace']['Z'],'sumarizace')

            


            self.output_data['zasedani']['hlasovani'] = self.combine_list_of_dicts(self.output_data['sumarizace'],self.output_data['zasedani']['hlasovani'])
            del self.output_data['sumarizace']
            

        #######zasedani-cislo
        if self.metafile_data['zastupitelstva'][0]['zasedani'].get('cislo') is None:
            print(f"ERROR: missing specification for \"zastupitelstvo.zasedani.cislo\"")
            exit(1) 
        if self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].get('data') is not None:
            sitting_number = self.metafile_data['zastupitelstva'][0]['zasedani']['cislo']
            self.change_dict_key_name(sitting_number,'cislo_zasedani','data')
            
        else:
            sitting_number = self.get_data_of_position(self.metafile_data['zastupitelstva'][0]['zasedani']['cislo']['start_x'],
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['cislo']['end_x'],
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['cislo']['start_y'],
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['cislo']['end_y'],
                                                    'cislo_zasedani',
                                                    (self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].get('_by_column')),
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].get('_type'),
                                                    self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].get('parameters'))
            sitting_number = self.flatten_output(sitting_number)
            sitting_number = self.apply_list_type_rule_on_list(sitting_number,'cislo',self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].get('_list_type'))
        if self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].get('_split_number') is not None:
            sitting_number = self.flatten_output(self.split_list_into_sublist_by_number(self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].get('_split_number'),
                                                                                        sitting_number,
                                                                                        self.metafile_data['zastupitelstva'][0]['zasedani']['cislo'].get('_delete_all_values_except_one')))


        self.output_data['zasedani']['hlasovani'] = self.combine_list_of_dicts(sitting_number,self.output_data['zasedani']['hlasovani'])
        print("INFO: Added \"zastupitelstva.zasedani.cislo\" data")
        #######agregate by value of "zasedani-cislo"
        self.output_data['zasedani'] = self.aggregate_values(self.output_data['zasedani']['hlasovani'],'cislo_zasedani','hlasovani','cislo')

        




        ###zastupitelstva part (one level higher)
        self.output_data['zastupitelstva'] = [{}]
        
        ###zastupitelstva-do
        if self.metafile_data['zastupitelstva'][0].get('do') is None:
            print(f"ERROR: missing specification for \"zastupitelstvo.do\"")
            exit(1) 
        council_to = ""
        if self.metafile_data['zastupitelstva'][0]['do'].get('data') is not None:
            council_to = self.metafile_data['zastupitelstva'][0]['do'].copy()
            self.change_dict_key_name(council_to,'do','data')
        else:
            council_to = self.flatten_output(self.get_data_of_position(self.metafile_data['zastupitelstva'][0]['do']['start_x'],
                                                    self.metafile_data['zastupitelstva'][0]['do']['end_x'],
                                                    self.metafile_data['zastupitelstva'][0]['do']['start_y'],
                                                    self.metafile_data['zastupitelstva'][0]['do']['end_y'],
                                                    'do',
                                                    (self.metafile_data['zastupitelstva'][0]['do'].get('_by_column')),
                                                    self.metafile_data['zastupitelstva'][0]['do'].get('_type'),
                                                    self.metafile_data['zastupitelstva'][0]['do'].get('parameters')))
        print("INFO: Added \"zastupitelstvo.do\" data")
        ###zastupitelstva-od
        if self.metafile_data['zastupitelstva'][0].get('od') is None:
            print(f"ERROR: missing specification for \"zastupitelstvo.od\"")
            exit(1) 
        council_from = ""
        if self.metafile_data['zastupitelstva'][0]['od'].get('data') is not None:
            council_from = self.metafile_data['zastupitelstva'][0]['od'].copy()
            self.change_dict_key_name(council_from,'od','data')
            
        else:
            council_from = self.flatten_output(self.get_data_of_position(self.metafile_data['zastupitelstva'][0]['od']['start_x'],
                                                    self.metafile_data['zastupitelstva'][0]['od']['end_x'],
                                                    self.metafile_data['zastupitelstva'][0]['od']['start_y'],
                                                    self.metafile_data['zastupitelstva'][0]['od']['end_y'],
                                                    'od',
                                                    (self.metafile_data['zastupitelstva'][0]['od'].get('_by_column')),
                                                    self.metafile_data['zastupitelstva'][0]['od'].get('_type'),
                                                    self.metafile_data['zastupitelstva'][0]['od'].get('parameters')))
            council_from = self.apply_list_type_rule_on_list(council_from,'od',self.metafile_data['zastupitelstva'][0]['od'].get('_list_type'))
        council_to = self.combine_dicts(council_to,council_from)
        print("INFO: Added \"zastupitelstva.od\" data")

        #poradiZastupitelstva
        if self.metafile_data['zastupitelstva'][0].get('poradiZastupitelstva') is None:
            print(f"ERROR: missing specification for \"zastupitelstvo.poradiZastupitelstva\"")
            exit(1) 
        if self.metafile_data['zastupitelstva'][0].get('poradiZastupitelstva') is not None:
            council_order = self.metafile_data['zastupitelstva'][0]['poradiZastupitelstva'].copy()
            self.change_dict_key_name(council_order,'poradiZastupitelstva','data')
            council_to = self.combine_dicts(council_to,council_order)

        #lidr
        leader_list = []
        if self.metafile_data['zastupitelstva'][0].get('lidr') is None:
            print(f"ERROR: missing specification for \"zastupitelstvo.lidr\"")
            exit(1) 
        for leader in self.metafile_data['zastupitelstva'][0]['lidr']:
            if leader['idZastupitel'].get('data') is not None:
                leader_id = leader['idZastupitel'].copy()
                self.change_dict_key_name(leader_id,'idZastupitel','data')
            if leader['funkce'].get('data') is not None:
                leader_func = leader['funkce'].copy()
                self.change_dict_key_name(leader_func,'funkce','data')
            leader_id = self.combine_dicts(leader_id,leader_func)
            if leader['od'].get('data') is not None:
                leader_od = leader['od'].copy()
                self.change_dict_key_name(leader_od,'od','data')
            else:
                leader_from = self.flatten_output(self.get_data_of_position(leader['od']['start_x'],
                                                   leader['od']['end_x'],
                                                   leader['od']['start_y'],
                                                   leader['od']['end_y'],
                                                   'od',
                                                   (leader['od']['end_x']-leader['od']['start_x']),
                                                   leader['od'].get('_type'),
                                                   leader['od'].get('parameters')))
                leader_from = self.apply_list_type_rule_on_list(leader_from,'od',leader['od'].get('_list_type'))
            leader_id = self.combine_dicts(leader_id,leader_from)
            if leader['do'].get('data') is not None:
                leader_to = leader['do']
                self.change_dict_key_name(leader_to,'do','data')
            else:
                leader_to = self.flatten_output(self.get_data_of_position(leader['do']['start_x'],
                                                   leader['do']['end_x'],
                                                   leader['do']['start_y'],
                                                   leader['do']['end_y'],
                                                   'do',
                                                   (leader['do']['end_x']-leader['do']['start_x']),
                                                   leader['do'].get('_type'),
                                                   leader['do'].get('parameters')))
                leader_to = self.apply_list_type_rule_on_list(leader_to,'do',leader['do'].get('_list_type'))
            leader_id = self.combine_dicts(leader_id,leader_to)
            leader_list.append(leader_id)
        leader_dict = {'lidr':leader_list}

        
        council_to = self.combine_dicts(council_to,leader_dict)
        print("INFO: Added \"zastupitelstva.lidr\" data")

        #coalition
        if self.metafile_data['zastupitelstva'][0].get('koalice') is None:
            print(f"ERROR: missing specification for \"zastupitelstvo.koalice\"")
            exit(1) 
        coalition_list = []
        for coalition in self.metafile_data['zastupitelstva'][0]['koalice']:
            if coalition['idPolitickeSubjekty'].get('data') is not None:
                coalition_ids = coalition['idPolitickeSubjekty'].copy()
                self.change_dict_key_name(coalition_ids,'idPolitickeSubjekty','data')
            if coalition['od'].get('data') is not None:
                coalition_from = coalition['od'].copy()
                self.change_dict_key_name(coalition_from,'od','data')
            else:
                coalition_from = self.flatten_output(self.get_data_of_position(coalition['od']['start_x'],
                                                   coalition['od']['end_x'],
                                                   coalition['od']['start_y'],
                                                   coalition['od']['end_y'],
                                                   'od',
                                                   (coalition['od']['end_x']-coalition['od']['start_x']),
                                                   coalition['od'].get('_type'),
                                                   coalition['od'].get('parameters')))
                coalition_from = self.apply_list_type_rule_on_list(coalition_from,'od',leader['od'].get('_list_type'))
            coalition_ids = self.combine_dicts(coalition_ids,coalition_from)
            if coalition['do'].get('data') is not None:
                coalition_to = coalition['do'].copy()
                self.change_dict_key_name(coalition_to,'do','data')
            else:
                coalition_to = self.flatten_output(self.get_data_of_position(coalition['do']['start_x'],
                                                   coalition['do']['end_x'],
                                                   coalition['do']['start_y'],
                                                   coalition['do']['end_y'],
                                                   'do',
                                                   (coalition['do']['end_x']-coalition['do']['start_x']),
                                                   coalition['do'].get('_type'),
                                                   coalition['do'].get('parameters')))
                coalition_to = self.apply_list_type_rule_on_list(coalition_to,'do',leader['do'].get('_list_type'))
            coalition_ids = self.combine_dicts(coalition_ids,coalition_to)
            coalition_list.append(coalition_ids)
        coalition_dict = {'koalice':coalition_list}

        
        council_to = self.combine_dicts(council_to,coalition_dict)
        print("INFO: Added \"zastupitelstvo.do\" data")
        #combining zasedani and other values on this level
        self.output_data['zastupitelstva'] = [{**council_to, **{'zasedani': self.output_data['zasedani']}}]
        del self.output_data['zasedani']

        #give derivatable values
        self.give_sittings_dates()
        print("INFO: Finished parsing of \"zastupitelstva\" data")
        return
    
    
    
    def concateneate_list_of_dicts_same_key(self,list1,list2,key_name):
        return [{key_name: str(elem1[key_name]) + str(elem2[key_name])} for elem1, elem2 in zip(list1, list2)]
        

    

    
    
    def give_sittings_dates(self):
        """
        Method for getting to one level higher in schema
        """
        for council in self.output_data['zastupitelstva']:
            for sitting in council['zasedani']:
                date_list = []
                for votings in sitting['hlasovani']:
                    try:
                        date_list.append(datetime.strptime(votings['datum'], '%Y-%m-%d'))
                    except:
                        date_list.append(votings["datum"])
                    votings.pop('datum')
                sitting['od'],sitting['do'] = self.get_min_max_in_list(date_list)
                if (sitting['od'] != "" and sitting['do'] != ""):
                    sitting['od'] = sitting['od'].strftime('%Y-%m-%d')
                    sitting['do'] = sitting['do'].strftime('%Y-%m-%d')
                    sitting['datum'] = sitting['od']
                    sitting.pop('od')
                    sitting.pop('do')
    
    def split_list_into_sublist_by_number(self,number,list_tb_splitted:list, delete_all_values_but_first=False)->list:
        """
        Method for splitting list into sublist by a number
        Useful when values are in the same row/column and cannot be distinguised

        Parameters:
        number(int or str or None): number of elements in sublist
        list_tb_splitted(list): list that need to be splitted
        delete_all_values_but_first(bool): deletes all values but the first one 
        """
        if number is None:
            return list_tb_splitted
        
        # when written as end
        if not isinstance(number,int):
            number = sys.maxsize


        return_list = [list_tb_splitted[i:i+number] for i in range(0, len(list_tb_splitted), number)]
        if delete_all_values_but_first:
            for list in return_list:
                del list[1:]
        return return_list
        

    def get_min_max_in_list(self,list):
        """
        Method for finding minimum and maximum value in a list

        Parameters:
        list: which list to find it in
        """
        return min(list), max(list)
    
    

   
                    
                    

    
    

    def give_party_ids_to_deputies_by_name(self):
        for deputy in self.output_data['zastupitele']:
            for party in deputy['politickeSubjekty']:
                if isinstance(party['idPolitickySubjekt'], str):
                    party['idPolitickySubjekt'] = self.get_id_of_party(party['idPolitickySubjekt'])
                    continue
                elif isinstance(party['idPolitickySubjekt'], str):
                    continue

    def get_id_of_party(self,party_name):
        for party in self.output_data['politickeSubjekty']:
            if party['zkrNazev'] == party_name:
                return party['id']


