import json
import os


class Output:
    """
    Class for outputting data into file
    """
    def __init__(self) -> None:
        self.__output = ''
        self.__unindented = ''

    
    def dump_output_file(self,output_file_name:str,output_data):
        """
        Method for outputting transformed json file

        Parameters:
        output_file_name(str): name of file that the output is written to
        output_data: data to be outputted
        """
        self.__output = output_data
        if os.path.isfile(output_file_name):
            os.remove(output_file_name)
        with open(output_file_name, 'a', encoding='utf-8') as output_file:
            json.dump(self.__output, output_file, indent=2, ensure_ascii=False)

    
    def dump_indented_file(self,indented_file_name,unintended_data):
        """
        Method for exporting indented data from input to be more readable 

        Parameters:
        indented_file_name(str): name of file that the indetented output is written to
        unindented_data: data to be outputted
        """ 
        self.__unindented = unintended_data
        with open(indented_file_name, 'w', encoding='utf-8') as output_file:
            json.dump(self.__unindented, output_file, indent=2, ensure_ascii=False)

