from .ListType import ListType
from datetime import datetime

class GetMinDateListType(ListType):
    """Get the minimum date in a list"""
    def __init__(self, list: list,key) -> None:
        super().__init__(list,key)

    def get_list(self) -> list:
        min_val = min(map(lambda date: datetime.strptime(date[self.key], "%Y-%m-%d").date(), self.list))
        min_val = min_val.strftime("%Y-%m-%d")
        return {self.key:min_val}