from .ListType import ListType
from datetime import datetime

class GetMaxDateListType(ListType):
    """Get the maximum date in a list"""
    def __init__(self, list: list,key) -> None:
        super().__init__(list,key)

    def get_list(self) -> list:
        max_val = max(map(lambda date: datetime.strptime(date[self.key], "%Y-%m-%d").date(), self.list))
        max_val = max_val.strftime("%Y-%m-%d")
        return {self.key:max_val}