from .Creator import Creator
from src.ListTypes.ListType import ListType
from src.ListTypes.GetMinListType import GetMinListType
from src.ListTypes.GetMaxListType import GetMaxListType
from src.ListTypes.GetMinDateListType import GetMinDateListType
from src.ListTypes.GetMaxDateListType import GetMaxDateListType
from src.StringTypes.StringType import StringType
from src.StringTypes.FromToStringType import FromToStringType
from src.StringTypes.VotesNameChangeStringtype import VotesNameChangeStringtype
from src.StringTypes.RegexSplitAndConcatStringType import RegexSplitAndConcatStringType
from src.StringTypes.RegexSplitStringType import RegexSplitStringType
from src.StringTypes.VoteApprovedChangeStringType import VoteApprovedChangeStringType
from src.StringTypes.RegexFIndAllStringType import RegexFindAllStringType
from src.StringTypes.DateStringType import DateStringType
from src.StringTypes.TImeStringType import TimeStringType
from src.StringTypes.ConcatWithDateStringType import ConcatWithDateStringType
from src.StringTypes.RegexTimeStringType import RegexTimeStringType
from src.StringTypes.RegexDateStringType import RegexDateStringType
from src.StringTypes.FunctionStringType import FunctionStringType
from src.StringTypes.FunctionFilenameStringType import FunctionFilenameStringType
from src.StringTypes.ChangeValueInTree import ChangeValueInTree
import sys


class ConcreteCreator(Creator):
    def get_value_by_type(self,value,value_type,value_params,user_fnc_file=None or str,filename=""):
        """
        Method for deciding which factory to use
        
        Parameters:
        value: concrete value
        value_type: type of the value meaning which factory to use
        parameters: parameters which factory uses
        """
        match value_type:
            case 'FromToStringType':
                if len(value_params) != 2:
                    print(f"{value_type} needs 2 parameters! Edit your metafile or use different type",file=sys.stderr)
                    exit(1)
                from_to_string_type = FromToStringType(value,value_params[0],value_params[1])
                return from_to_string_type.get_value()
            case 'VotesNameChangeStringType':
                if len(value_params) != 6:
                    print(f"{value_type} needs 6 parameters! Edit your metafile or use different type",file=sys.stderr)
                    exit(1)
                votes_name_change_string_type = VotesNameChangeStringtype(value,value_params[0],value_params[1],value_params[2],value_params[3],value_params[4],value_params[5])
                return votes_name_change_string_type.get_value()
            case 'VoteApprovedChangeStringType':
                if len(value_params) != 2:
                    print(f"{value_type} needs 2 parameters! Edit your metafile or use different type",file=sys.stderr)
                    exit(1)
                votes_approved_change_string_type = VoteApprovedChangeStringType(value,value_params[0],value_params[1])
                return votes_approved_change_string_type.get_value()
            case 'RegexSplitStringType':
                if len(value_params) != 2:
                    print(f"{value_type} needs 2 parameters! Edit your metafile or use different type",file=sys.stderr)
                    exit(1)
                regex_string_type = RegexSplitStringType(value,value_params[0],value_params[1])
                return regex_string_type.get_value()
            case 'RegexSplitAndConcatStringType':
                if len(value_params) != 3:
                    print(f"{value_type} needs 3 parameters! Edit your metafile or use different type",file=sys.stderr)
                    exit(1)
                regex_string_type = RegexSplitAndConcatStringType(value,value_params[0],value_params[1],value_params[2])
                return regex_string_type.get_value()
            case 'RegexFindAllStringType':
                if len(value_params) != 2:
                    print(f"{value_type} needs 2 parameters! Edit your metafile or use different type",file=sys.stderr)
                    exit(1)
                regex_string_type = RegexFindAllStringType(value,value_params[0],value_params[1])
                return regex_string_type.get_value()
            case 'DateStringType':
                if len(value_params) != 1:
                    print(f"{value_type} needs 1 parameter! Edit your metafile or use different type",file=sys.stderr)
                    exit(1)
                date_string_type = DateStringType(value,value_params[0])
                return date_string_type.get_value()
            case 'ConcatWithDateStringType':
                if len(value_params) != 2:
                    print(f"{value_type} needs 2 parameters! Edit your metafile or use different type",file=sys.stderr)
                    exit(1)
                concat_date_string_type = ConcatWithDateStringType(value,value_params[0],value_params[1])
                return concat_date_string_type.get_value()
            case 'TimeStringType':
                if len(value_params) != 1:
                    print(f"{value_type} needs 1 parameter! Edit your metafile or use different type",file=sys.stderr)
                    exit(1)
                time_string_type = TimeStringType(value,value_params[0])
                return time_string_type.get_value()
            case 'RegexTimeStringType':
                if len(value_params) != 2:
                    print(f"{value_type} needs 2 parameter! Edit your metafile or use different type",file=sys.stderr)
                    exit(1)
                time_string_type = RegexTimeStringType(value,value_params[0],value_params[1])
                return time_string_type.get_value()
            case 'RegexDateStringType':
                if len(value_params) != 2:
                    print(f"{value_type} needs 2 parameter! Edit your metafile or use different type",file=sys.stderr)
                    exit(1)
                time_string_type = RegexDateStringType(value,value_params[0],value_params[1])
                return time_string_type.get_value()
            case 'FunctionStringType':
                function_string_type = FunctionStringType(value,value_params['function_name'],value_params['function_parameters'],user_fnc_file)
                return function_string_type.get_value()
            case 'FunctionFilenameStringType':
                function_filename_string_type = FunctionFilenameStringType(value,filename,value_params['function_name'],value_params['function_parameters'],user_fnc_file)
                return function_filename_string_type.get_value()

            case 'ChangeValueInTree':
                if len(value_params) != 2:
                    print(f"{value_type} needs 3 parameters! Edit your metafile or use different type",file=sys.stderr)
                    exit(1)
                change_value_in_tree = ChangeValueInTree(value,value_params[0],value_params[1])
                return change_value_in_tree.get_value()
            case 'ChangeDeputyPartyValueInDateInterval':
                change_value_in_tree = StringType(value)
                return change_value_in_tree.get_value()
            case _:
                print(f"Type:{value_type} not known -- edit your metafile!")
                exit(1)

    def get_list_value_by_type(self,list,list_type,key):
        match list_type:
            case 'GetMinDateListType':
                get_min_date_list = GetMinDateListType(list,key)
                value = [get_min_date_list.get_list()]
                return value
            case 'GetMaxDateListType':
                get_max_date_list = GetMaxDateListType(list,key)
                return [get_max_date_list.get_list()]
            case 'GetMinListType':
                get_min_list = GetMinListType(list,key)
                return [get_min_list.get_list()]
            case 'GetMaxListType':
                get_max_list = GetMaxListType(list,key)
                return [get_max_list.get_list()]
            case _:
                print(f"Type:{list_type} not known -- edit your metafile!")
                exit(1)
        