import sys
from datetime import datetime



class CombineMultipleDataRecords():
    def __init__(self,data_in_list:list,metafile_data) -> None:
        self.data_in_list = data_in_list
        self.output_data = {}
        self.metafile_data = metafile_data

    def get_output_data(self, only_combine=False):
        if len(self.data_in_list) == 1:
            return self.data_in_list[0]
        self.data_in_list = sorted(self.data_in_list, key=lambda x: datetime.strptime(x['zastupitelstva'][0]['zasedani'][0]['datum'], '%Y-%m-%d'))

        self.combine_municipality()
        self.combine_parties(only_combine)
        self.combine_deputies(only_combine)
        self.combine_councils()
        self.combine_sitting_with_same_date()
        for council in self.output_data['zastupitelstva']:
            council['zasedani'].sort(key=lambda sit_dict: datetime.strptime(sit_dict['datum'], '%Y-%m-%d'))
        if only_combine:
            self.split_only_combine()
        return self.output_data
    
    def combine_municipality(self):
        previous = ""
        for element in self.data_in_list:
            if previous == "":
                previous = element['municipalita']
            elif element['municipalita'] == previous:
                previous = element['municipalita']
                del element['municipalita']
                self.output_data['municipalita'] = previous
                return
            else:
                print("Key \"municipalita\" does not have same values!",file=sys.stderr)

    def split_only_combine(self):
        if self.metafile_data['zastupitelstva'][0] is None:
            return self.output_data
        if self.metafile_data['zastupitelstva'][0].get('_split_date') is None:
            if self.output_data['zastupitele'][0]['politickeSubjekty'][0].get('poradiZastupitelstva') is not None:
                return self.output_data
            else:
                for deputy in self.output_data['zastupitele']:
                    for party in deputy['politickeSubjekty']:
                        party['poradiZastupitelstva'] = self.output_data['zastupitelstva'][0]['poradiZastupitelstva']
        
        

        split_dates = [date['_split_date'] for date in self.metafile_data['zastupitelstva'] if date.get('_split_date') is not None]
        split_dates = [datetime.strptime(date, '%Y-%m-%d') for date in split_dates]
        split_lists = []
        copied_output = self.output_data['zastupitelstva'][0]['zasedani'].copy() #assume data are not splitted into more parts yet
        for split_date in split_dates:
            split_list = [entry for entry in copied_output if datetime.strptime(entry['datum'], '%Y-%m-%d') <= split_date] # list of part until split date
            split_lists.append(split_list)
            copied_output = [entry for entry in copied_output if datetime.strptime(entry['datum'], '%Y-%m-%d') > split_date] # list of the rest of council
        split_lists.append(copied_output)

        del self.metafile_data['zastupitelstva'][0]["_split_date"]

        council_list = []
        for i, one_part in enumerate(split_lists):
            
            council_list.append([])
            council_list[i] = {}
            council_list[i] = self.metafile_data['zastupitelstva'][i]
            if council_list[i]['koalice'][0].get('od') is None:
                council_list[i]['koalice'][0]['od'] = max(one_part, key=lambda x: datetime.strptime(x["datum"], "%Y-%m-%d"))['datum']
            if council_list[i]['lidr'][0].get('od') is None:
                council_list[i]['lidr'][0]['od'] = max(one_part, key=lambda x: datetime.strptime(x["datum"], "%Y-%m-%d"))['datum']


            if council_list[i]['koalice'][-1].get('do') is None:
                council_list[i]['koalice'][-1]['do'] = max(one_part, key=lambda x: datetime.strptime(x["datum"], "%Y-%m-%d"))['datum']
            if council_list[i]['lidr'][-1].get('do') is None:
                council_list[i]['lidr'][-1]['do'] = max(one_part, key=lambda x: datetime.strptime(x["datum"], "%Y-%m-%d"))['datum']
            council_list[i]['zasedani'] = []
            council_list[i]['zasedani'] = one_part
        self.output_data['zastupitelstva'] = council_list




    def combine_parties(self,only_combine=False):
        outer_index = 0
        first_parties = self.data_in_list[0]['politickeSubjekty']
        while outer_index < len(self.data_in_list)-1:
            
            second_parties = self.data_in_list[outer_index+1]['politickeSubjekty']
            second_people = self.data_in_list[outer_index+1]['zastupitele']

            first_parties_max = max(item['id'] for item in first_parties)

            # update parties ids by the length of the first council to not have colision
            for party in second_parties:
                party['id'] += first_parties_max 


            if only_combine == True:
                for person in second_people:
                    for political_party in person['politickeSubjekty']:
                        political_party['idPolitickySubjekt'] += first_parties_max
            else:
                #update people ids by the lenght of the first council to not have colision
                for person in second_people:
                    person['politickeSubjekty'][-1]['idPolitickySubjekt'] += first_parties_max
                

            # list of items to be deleted
            index_items_to_delete = []

            # find duplicates
            for i, second_party in enumerate(second_parties):
                for first_party in first_parties:
                    if first_party['zkrNazev'] == second_party['zkrNazev']:
                        item_id = second_party['id']
                        for person in second_people:
                            #when the subject subject is duplicate go back with ids of people
                            if only_combine == True:
                                for political_party in person['politickeSubjekty']:
                                    if political_party['idPolitickySubjekt'] == item_id:
                                        political_party['idPolitickySubjekt'] = first_party['id']    
                            else:
                                if person['politickeSubjekty'][-1]['idPolitickySubjekt'] == item_id:
                                    person['politickeSubjekty'][-1]['idPolitickySubjekt'] = first_party['id']
                        index_items_to_delete.append(i)
                        break

            # delete duplicates after main loop, go from back to delete it right 
            for index in sorted(index_items_to_delete, reverse=True):
                del second_parties[index]
            
            list_of_changed = []

            second_parties.reverse()
            for i, party in enumerate(second_parties):
                list_of_changed.append((party['id'],first_parties_max + i + 1))
                party['id'] = first_parties_max + i + 1
                
            for person in second_people:
                for changed_party in list_of_changed:
                    if only_combine == True:
                        for political_party in person['politickeSubjekty']:
                            if political_party['idPolitickySubjekt'] == changed_party[0] and political_party.get('changed') is None:
                                political_party['idPolitickySubjekt'] = changed_party[1]
                    else:
                        if person['politickeSubjekty'][-1]['idPolitickySubjekt'] == changed_party[0]:
                            person['politickeSubjekty'][-1]['idPolitickySubjekt'] = changed_party[1]
                            break

            if only_combine:
                for person in second_people:
                    for changed_party in list_of_changed:
                        for political_party in person['politickeSubjekty']:
                            if political_party.get('changed') is not None:
                                del political_party['changed']


            self.output_data['politickeSubjekty'] = first_parties + second_parties

            outer_index += 1
            first_parties = self.output_data['politickeSubjekty'].copy()

    def get_duplicate_deputies(self,duplicate_names_list,seen_people,second_people,first_people_max) -> str:
        """Method for getting shortened name of party by its id"""
        for person in second_people:
                person['id'] += first_people_max
                name_pair = (person.get("jmeno"), person.get("prijmeni"))
                
                # If this pair has been seen before, add both first occurrence and the current one
                if name_pair in seen_people:
                    # Add the first occurrence if not already added
                    if seen_people[name_pair] not in duplicate_names_list:
                        duplicate_names_list.append(seen_people[name_pair])
                    # Add the current duplicate
                    duplicate_names_list.append(person)
                else:
                    # Store the first occurrence of the pair
                    seen_people[name_pair] = person
        

    def combine_deputies(self,only_combine=False):


        outer_index = 0
        first_people = self.data_in_list[0]['zastupitele']
        while outer_index < len(self.data_in_list) - 1:
            
            second_people = self.data_in_list[outer_index+1]['zastupitele']
            second_council = self.data_in_list[outer_index+1]['zastupitelstva']
            first_people_max = max(item['id'] for item in first_people)

            #when names are duplicate
            duplicate_names_list = []

            #for checking duplicity
            seen_people = {}
            self.get_duplicate_deputies(duplicate_names_list,seen_people,second_people,first_people_max)
            # update votes deputy ids by the length of the first council to not have colision
            for council in second_council:
                for sitting in council['zasedani']:
                    for voting in sitting['hlasovani']:
                        if voting.get('zastupiteleHlasy') is None:
                            continue
                        for vote in voting['zastupiteleHlasy']:
                            vote['idZastupitel'] += first_people_max 
            
            # list of items to be deleted
            index_items_to_delete = []
        
            for i, second_person in enumerate(second_people):
                for first_person in first_people:
                    if first_person['prijmeni'] == second_person['prijmeni'] and first_person['jmeno'] == second_person['jmeno']:
                        
                        is_duplicate = 0
                        for person in duplicate_names_list:
                            if person['prijmeni'] == second_person['prijmeni'] and person['jmeno'] == second_person['jmeno']:
                                is_duplicate = 1
                                #is duplicate and the party is the same
                                if person['prijmeni'] == second_person['prijmeni'] and person['jmeno'] == second_person['jmeno'] and person['politickeSubjekty'][-1]['idPolitickySubjekt'] == second_person['politickeSubjekty'][-1]['idPolitickySubjekt']:
                                    for f_person in first_people:
                                        if person['prijmeni'] == f_person['prijmeni'] and person['jmeno'] == f_person['jmeno'] and person['politickeSubjekty'][-1]['idPolitickySubjekt'] == f_person['politickeSubjekty'][-1]['idPolitickySubjekt']:
                                            duplicate = f_person
                                            for index, element in enumerate(duplicate_names_list):
                                                #when combining two datasets with 2 people with same name on the edge of the dataset 
                                                if element['politickeSubjekty'][-1]['idPolitickySubjekt'] == f_person['politickeSubjekty'][-1]['idPolitickySubjekt']:
                                                    del duplicate_names_list[index]
                                                    break
                                            break
                        
                        item_id = second_person['id']
                        
                        for council in second_council:
                            for sitting in council['zasedani']:
                                for voting in sitting['hlasovani']:
                                    if voting.get('zastupiteleHlasy') is None:
                                        continue
                                    for vote in voting['zastupiteleHlasy']:
                                        if vote['idZastupitel'] == item_id:
                                            if is_duplicate == 1:
                                                #when combining two datasets with 2 people with same name on the edge of the dataset
                                                if second_person not in duplicate_names_list:
                                                    vote['idZastupitel'] = duplicate['id']
                                            else:
                                                vote['idZastupitel'] = first_person['id']
                        
                        if is_duplicate == 1:
                            #when combining two datasets with 2 people with same name on the edge of the dataset 
                            if second_person in duplicate_names_list:
                                break
                            first_person = duplicate
                        self.update_party_membership(first_person,second_person,only_combine)
                        index_items_to_delete.append(i)

                        break
            
            # delete duplicates after main loop, go from back to delete it right 
            for index in sorted(index_items_to_delete, reverse=True):
                del second_people[index]


            list_of_changed = []

            for i, person in enumerate(second_people):
                list_of_changed.append((person['id'],first_people_max + i + 1))
                person['id'] = first_people_max + i + 1
                
            for person in second_people:
                for changed_person in list_of_changed:
                    if person['id'] == changed_person[0]:
                        person['id'] = changed_person[1]
            
            for council in second_council:
                for sitting in council['zasedani']:
                    for voting in sitting['hlasovani']:
                        if voting.get('zastupiteleHlasy') is None:
                            continue
                        for vote in voting['zastupiteleHlasy']:
                            for changed_person in list_of_changed:
                                if vote['idZastupitel'] == changed_person[0]:
                                    vote['idZastupitel'] = changed_person[1]
                            
            self.output_data['zastupitele'] = first_people + second_people
            outer_index += 1
            first_people = self.output_data['zastupitele'].copy()

    def update_party_membership(self,first_person, second_person,only_combine):
        date1_to = datetime.strptime(first_person['politickeSubjekty'][-1]['do'], '%Y-%m-%d')
        date2_to = datetime.strptime(second_person['politickeSubjekty'][-1]['do'], '%Y-%m-%d')
        date1_from = datetime.strptime(first_person['politickeSubjekty'][-1]['od'], '%Y-%m-%d')
        date2_from = datetime.strptime(second_person['politickeSubjekty'][-1]['od'], '%Y-%m-%d')
        if only_combine == False:
            if first_person['politickeSubjekty'][-1]['idPolitickySubjekt'] == second_person['politickeSubjekty'][-1]['idPolitickySubjekt']:
                #deputy did not change party
                first_person['politickeSubjekty'][-1]['do'] = max(date1_to, date2_to).strftime('%Y-%m-%d')
                first_person['politickeSubjekty'][-1]['od'] = min(date1_from, date2_from).strftime('%Y-%m-%d')
            else:
                #deputy changed party
                first_person['politickeSubjekty'] = sorted(first_person['politickeSubjekty'], key=lambda x: datetime.strptime(x['od'], '%Y-%m-%d'))
                first_person['politickeSubjekty'].append({'od':second_person['politickeSubjekty'][-1]['od'],
                                                        'do':second_person['politickeSubjekty'][-1]['do'],
                                                        "idPolitickySubjekt":second_person['politickeSubjekty'][-1]['idPolitickySubjekt'],
                                                        "poradiZastupitelstva":second_person['politickeSubjekty'][-1]['poradiZastupitelstva']})
        else:
            #only combining multiple files 
            first_person['politickeSubjekty'] = self.combine_date_ranges(first_person['politickeSubjekty'],second_person['politickeSubjekty'])
        # Function to combine lists
    def combine_multiple_date_ranges(self,list1, list2):
        combined_list = []

        # Combine the lists using the same logic as before
        for item1 in list1:
            for item2 in list2:
                if item1['idPolitickySubjekt'] == item2['idPolitickySubjekt'] and item1['poradiZastupitelstva'] == item2['poradiZastupitelstva']:
                    # Find the earliest start date and the latest end date
                    start_date = min(datetime.strptime(item1['od'], '%Y-%m-%d'), datetime.strptime(item2['od'], '%Y-%m-%d')).strftime('%Y-%m-%d')
                    end_date = max(datetime.strptime(item1['do'], '%Y-%m-%d'), datetime.strptime(item2['do'], '%Y-%m-%d')).strftime('%Y-%m-%d')
                    
                    combined_list.append({
                        'od': start_date,
                        'do': end_date,
                        'idPolitickySubjekt': item1['idPolitickySubjekt'],
                        'poradiZastupitelstva': item1['poradiZastupitelstva']
                    })
        
        return combined_list



    def combine_date_ranges(self,date1to, date2to):
        def parse_date(date_str):
            return datetime.strptime(date_str, '%Y-%m-%d')
        
        combined = date1to + date2to
        
        # Sort the combined list by 'od' (start date)
        combined_sorted = sorted(combined, key=lambda x: parse_date(x['od']))
        
        merged_ranges = []
        
        for current in combined_sorted:
            if not merged_ranges:
                merged_ranges.append(current)
            else:
                last = merged_ranges[-1]
                
                # Check if the current range overlaps or is adjacent to the last range
                if (last['idPolitickySubjekt'] == current['idPolitickySubjekt'] and 
                    last['poradiZastupitelstva'] == current['poradiZastupitelstva']):
                    
                    # Merge the ranges by updating the end date if necessary
                    last['do'] = max(last['do'], current['do'], key=parse_date)
                    last['od'] = min(last['od'], current['od'], key=parse_date)
                elif parse_date(current['od']) <= parse_date(last['do']):
                    # Merge overlapping or adjacent ranges
                    last['do'] = max(last['do'], current['do'], key=parse_date)
                else:
                    merged_ranges.append(current)
        
        return merged_ranges
            





    def combine_councils(self):
        i = 0
        self.data_in_list = sorted(self.data_in_list,key=lambda x: datetime.strptime(x['zastupitelstva'][0]['zasedani'][0]['datum'], '%Y-%m-%d'))
        while i < len(self.data_in_list):
            if i == 0:
                self.output_data['zastupitelstva'] = self.data_in_list[i]['zastupitelstva']
            else:
                first_council = self.data_in_list[i]['zastupitelstva']
                self.update_council_and_coalition_dates(self.output_data['zastupitelstva'][0],first_council[0])
                self.output_data['zastupitelstva'][0]['zasedani'] = self.output_data['zastupitelstva'][0]['zasedani']+first_council[0]['zasedani']  
            i = i+1

    def combine_sitting_with_same_date(self):
        # Dictionary to track occurrences of each key
        occurrences = {}
        duplicates = []

        # Iterate through the list of dictionaries
        for item in self.output_data['zastupitelstva'][0]['zasedani']:
            key = item['datum']
            
            if key in occurrences:
                # Append the dictionary to the existing list of duplicates
                occurrences[key].append(item)
            else:
                # Initialize the list with the first occurrence
                occurrences[key] = [item]

        # Filter out and create sublists for keys with more than one occurrence
        for key, items in occurrences.items():
            if len(items) > 1:
                duplicates.append(items)


        for element in duplicates:
            sitting = []
            for one_sitting in element:
                sitting += one_sitting['hlasovani']
            element[0]['hlasovani'] = sitting
            if element[0]['hlasovani'][0].get('cas') is not None:
                element[0]['hlasovani'].sort(key=lambda sit_dict: datetime.strptime(sit_dict['cas'], '%H:%M:%S'))
            else:
                element[0]['hlasovani'].sort(key=lambda sit_dict: sit_dict['cislo'])
            for sitting in self.output_data['zastupitelstva'][0]['zasedani']:
                if sitting['datum'] == element[0]['datum']:
                    sitting = element[0]


        used_date = []
        all_sittings = []
        for sitting in self.output_data['zastupitelstva'][0]['zasedani']:
            if sitting['datum'] not in used_date:
                all_sittings.append(sitting)
                used_date.append(sitting['datum'])
            
        self.output_data['zastupitelstva'][0]['zasedani'] = all_sittings


    def update_council_and_coalition_dates(self,first, second):
        date1_to = datetime.strptime(first['lidr'][-1]['do'], '%Y-%m-%d')
        date2_to = datetime.strptime(second['lidr'][-1]['do'], '%Y-%m-%d')
        date1_from = datetime.strptime(first['lidr'][-1]['od'], '%Y-%m-%d')
        date2_from = datetime.strptime(second['lidr'][-1]['od'], '%Y-%m-%d')

        if first['lidr'][-1]['idZastupitel'] == second['lidr'][-1]['idZastupitel']:
            first['lidr'][-1]['do'] = max(date1_to, date2_to).strftime('%Y-%m-%d')
            first['lidr'][-1]['od'] = min(date1_from, date2_from).strftime('%Y-%m-%d')
        else:
            first['lidr'] = sorted(first['lidr'], key=lambda x: datetime.strptime(x['od'], '%Y-%m-%d'))
            first['lidr'].append({'od':second['lidr'][-1]['od'],
                                  'do':second['lidr'][-1]['do'],
                                  "idPolitickySubjekt":second['lidr'][-1]['idZastupitel'],
                                  "funkce":second['lidr'][-1]['funkce']}) 

        date1_to = datetime.strptime(first['koalice'][-1]['do'], '%Y-%m-%d')
        date2_to = datetime.strptime(second['koalice'][-1]['do'], '%Y-%m-%d')
        date1_from = datetime.strptime(first['koalice'][-1]['od'], '%Y-%m-%d')
        date2_from = datetime.strptime(second['koalice'][-1]['od'], '%Y-%m-%d')

        if first['koalice'][-1]['idPolitickeSubjekty'] == second['koalice'][-1]['idPolitickeSubjekty']:
            first['koalice'][-1]['do'] = max(date1_to, date2_to).strftime('%Y-%m-%d')
            first['koalice'][-1]['od'] = min(date1_from, date2_from).strftime('%Y-%m-%d')
        else:
            first['koalice'] = sorted(first['koalice'], key=lambda x: datetime.strptime(x['od'], '%Y-%m-%d'))
            first['koalice'].append({'od':second['koalice'][-1]['od'],
                                  'do':second['koalice'][-1]['do'],
                                  "idPolitickeSubjekty":second['koalice'][-1]['idPolitickeSubjekty']}) 

