from src.Parser.TreeFileParser import TreeFileParser
from src.Parser.TableFIleParser import TableFileParser
from src.Metafile import Metafile
from src.Output import Output
from src.CombineMultipleDataRecords import CombineMultipleDataRecords
from src.Parser.CommonParser import CommonParser
import sys
import os
import csv
import json
import gender_guesser.detector as gender
from genderize import Genderize, GenderizeException
import xmltodict
import chardet
from lxml import html, etree
from datetime import datetime



class Args_check:
    """
    Class for checking terminal input
    """
    def __init__(self):
        #./transform -mf metafile.json -i inputfile.csv
        self.meta_file = ''
        self.input_file = ''
        self.input_file_format = ''
        self._argc = 0
        self.viable_formats = ['json','csv','xml','html']

        self.metafile_data = {}
        self.output_data = {}
        self.data = {}
 
    
    def args_check(self):
        """
        Check arguments validity
        """
        self._argc = len(sys.argv)
        if (self._argc != 3):
            print('Wrong number of paramaters ',file=sys.stderr)
            exit(1)
        #skip first argument(script name)
        for arg in range(1,self._argc,2):
            if sys.argv[arg] == "-mf":
                self.meta_file = self.check_meta_file(sys.argv[arg+1])
                metafile = Metafile()
                metafile.read_metafile(self.meta_file)
                self.metafile_data = metafile.get_metafile_data()
            else:
                print('Wrong arguments of command line, should be this structure:',file=sys.stderr)
                print('./transform -mf <metafile.json>',file=sys.stderr)
                exit(1)

    
    
    def check_meta_file(self,filename: str) -> str:
        """
        Check if meta file is of viable format

        Parameters:
            filename (str): name of file to be checked
        """
        filename_dot_pos = filename.find('.')
        format = filename[filename_dot_pos+1:]
        if format == 'json':
            return filename
        else:
            print('This format is not accepted by this script,',file=sys.stderr)
            print('Metafile must be in json format',file=sys.stderr)
            exit(1)

    
    def get_gender(self):
        """
        Method for assigning gender to each person
        """
        women_list = []
        men_list = []

        if self.metafile_data['zastupitele'].get('pohlavi') is not None:
            return
        
        detector = gender.Detector()
        genderize = Genderize()
        for person in self.output_data['zastupitele']:
            if person['jmeno'] in women_list:
                person['pohlavi'] = True
                continue
            if person['jmeno'] in men_list:
                person['pohlavi'] = False
                continue
            deputy_gender = detector.get_gender(person['jmeno'])
            if deputy_gender == "female" or deputy_gender == "mostly female":
                women_list.append(person['jmeno'])
                person['pohlavi'] = True
            elif deputy_gender == "unknown":
                try:
                    deputy_gender = genderize.get([person['jmeno']]) #lib needs str in a list
                    if deputy_gender[0]['gender'] == 'female':
                        women_list.append(person['jmeno'])
                        person['pohlavi'] = True
                        continue
                    men_list.append(person['jmeno'])
                    person['pohlavi'] = False
                except GenderizeException as e:
                    print(f'Too many queries for Genderize library!',file=sys.stderr)
                    person['pohlavi'] = False
                    continue
            else:
                men_list.append(person['jmeno'])
                person['pohlavi'] = False

    def check_validity_of_votings(self):
        if self.metafile_data['config'].get('_get_validity') != True:
            return
        last = ""
        for council in self.output_data['zastupitelstva']:
            for sitting in council['zasedani']:
                for index, voting in enumerate(sitting['hlasovani']):
                    current = voting['projednavano'][0]['predmetHlasovani']
                    if current == last:
                        sitting['hlasovani'][index-1]['platne'] = False
                    last = current

    def check_procedurality_of_votings(self):
        if not isinstance(self.metafile_data['config'].get('_get_procedurality'), str):
            return
        procedurality_substr = self.metafile_data['config'].get('_get_procedurality')
        for council in self.output_data['zastupitelstva']:
            for sitting in council['zasedani']:
                for voting in sitting['hlasovani']:
                    current = voting['projednavano'][0]['predmetHlasovani']
                    if procedurality_substr in current:
                        voting['proceduralni'] = True
                        continue
                    voting['proceduralni'] = False

    def give_values_after_multiple_files_transform(self,one_file):
        common_parser = CommonParser(self.metafile_data,one_file)
        if one_file == True:
            return self.output_data
        
        self.output_data['politickeSubjekty'].sort(key=lambda x: x['zkrNazev'])
        if self.metafile_data['politickeSubjekty'].get('barva') is not None:
            if self.metafile_data['politickeSubjekty']['barva'].get('data') is not None:
                colour = self.metafile_data['politickeSubjekty']['barva'].copy()
                colour = common_parser.give_dicts_key(colour['data'],'barva')
                parties = self.output_data['politickeSubjekty'].copy()
                parties = common_parser.combine_list_of_dicts(parties,colour)
                self.output_data['politickeSubjekty'] = parties
        
        if self.metafile_data['config'].get('_data_to_combine') is not None:
            try:
                if self.metafile_data['zastupitelstva'][0].get('zasedani').get('cislo').get("_give_value_when_combine") == True:
                    common_parser.output_data = self.output_data.copy()
                    common_parser.give_sitting_number_to_all_sittings()
                    self.output_data = common_parser.output_data.copy()
            except AttributeError:
                return self.output_data
        return self.output_data



    def detect_encoding(self,file_path):
        """
        Method for getting info about encoding
        
        Parameters:
        file_path: path to file of encoding that needs to be known
        """
        if self.metafile_data['config'].get('_encoding') is not None:
            return self.metafile_data['config']['_encoding']

        with open(file_path, 'rb') as f:
            raw_data = f.read()
            result = chardet.detect(raw_data)['encoding']
            if result:
                return result
            print(f"Unknown encoding of file {file_path}",file=sys.stderr)
            exit(1)
    
    
    def transform_with_input_file_format(self):
        """
        Executes transformation judging by the format of input file
        """
        dir_input = self.metafile_data['config']['directory_input']

        files = os.listdir(dir_input)
        if len(files) == 1:
            one_file = True
        else:
            one_file = False
        appended = []
        if self.metafile_data['config'].get('_data_to_combine') is not None:
            for file in files:
                print(dir_input)
                print(os.path.join(dir_input, file))
                with open(os.path.join(dir_input, file), 'r', newline='',encoding='UTF-8') as json_file:
                    one_part = json.load(json_file)
                    appended.append(one_part)
            print(appended)
            combine_multiple_records = CombineMultipleDataRecords(appended,self.metafile_data)
            self.output_data = combine_multiple_records.get_output_data(True)
            self.output_data = self.give_values_after_multiple_files_transform(False)
            output = Output()
            output.dump_output_file(self.metafile_data['config']['output_file'] if self.metafile_data['config'].get('output_file') is not None else 'out.json',self.output_data)
            print("INFO: OK")
            exit(0)
            

        for file in files:
            # check if is a file not a directory
            if os.path.isfile(os.path.join(dir_input, file)):
                
                file_path = os.path.join(dir_input, file)
                print("INFO: Executing_file:",file)
                table_file_parser = TableFileParser(self.metafile_data,one_file,file_path,by_sittings_or_more=True)
                tree_file_parser = TreeFileParser(self.metafile_data,one_file,file_path,by_sittings_or_more=True)
                file_encoding = self.detect_encoding(file_path)
                if (self.metafile_data['config']['format'] == 'csv'):
                    with open(file_path, 'r', newline='',encoding=file_encoding) as csvfile:
                        self.data = list(csv.reader(csvfile,delimiter=self.metafile_data['config']['_delimiter']))
                    # open file
                    one_output = table_file_parser.parse_file(self.data)
                    appended.append(one_output)
                elif (self.metafile_data['config']['format'] == 'xml'):
                    with open(file_path, 'r', newline='',encoding=file_encoding) as xml_file:
                        self.data = xmltodict.parse(xml_file.read())
                        one_output = tree_file_parser.parse_file(self.data)
                        appended.append(one_output)
                elif (self.metafile_data['config']['format'] == 'json'):
                    with open(file_path, 'r', newline='',encoding=file_encoding) as json_file:
                        self.data = json.load(json_file)
                        one_output = tree_file_parser.parse_file(self.data)
                        appended.append(one_output)
                elif (self.metafile_data['config']['format'] == 'html'):
                    with open(file_path, 'r',encoding=file_encoding) as html_file:
                        html_data = html.fromstring(html_file.read())
                        xml_data = etree.tostring(html_data, pretty_print=True, encoding='UTF-8', xml_declaration=True)
                        self.data = xmltodict.parse(xml_data)
                        one_output = tree_file_parser.parse_file(self.data)
                        appended.append(one_output)
            else:
                listed_dir =  os.listdir(os.path.join(dir_input, file))
                path_of_dir = os.path.join(dir_input, file)
                one_file = False
                for index, voting_file in enumerate(listed_dir):
                    print("INFO: Executing_file:",file,"/",voting_file)
                    tree_file_parser = TreeFileParser(self.metafile_data,one_file,os.path.join(path_of_dir, voting_file),by_sittings_or_more=False)
                    file_encoding = self.detect_encoding(os.path.join(path_of_dir, voting_file))
                    if (self.metafile_data['config']['format'] == 'html'):
                        with open(os.path.join(path_of_dir, voting_file), 'r',encoding=file_encoding) as html_file:
                            html_data = html.fromstring(html_file.read())
                            xml_data = etree.tostring(html_data, pretty_print=True, encoding='UTF-8', xml_declaration=True)
                            self.data = xmltodict.parse(xml_data)
                            if index == 0:
                                one_sitting_output = tree_file_parser.parse_file(self.data)
                            else:
                                not_first_voting_output = tree_file_parser.parse_file(self.data)
                                one_sitting_output['zastupitelstva'][0]['zasedani'][0]['hlasovani'].append(not_first_voting_output['zastupitelstva'][0]['zasedani'][0]['hlasovani'][0])
                    elif (self.metafile_data['config']['format'] == 'xml'):
                        with open(os.path.join(path_of_dir, voting_file), 'r', newline='',encoding=file_encoding) as xml_file:
                            self.data = xmltodict.parse(xml_file.read())
                            if index == 0:
                                one_sitting_output = tree_file_parser.parse_file(self.data)
                            else:
                                not_first_voting_output = tree_file_parser.parse_file(self.data)
                                one_sitting_output['zastupitelstva'][0]['zasedani'][0]['hlasovani'].append(not_first_voting_output['zastupitelstva'][0]['zasedani'][0]['hlasovani'][0])
                if one_sitting_output['zastupitelstva'][0]['zasedani'][0]['hlasovani'][0].get('cas') is not None:
                    one_sitting_output['zastupitelstva'][0]['zasedani'][0]['hlasovani'].sort(key=lambda sit_dict: datetime.strptime(sit_dict['cas'], '%H:%M:%S'))
                else:
                    one_sitting_output['zastupitelstva'][0]['zasedani'][0]['hlasovani'].sort(key=lambda sit_dict: sit_dict['cislo'])
                appended.append(one_sitting_output)

        combine_multiple_records = CombineMultipleDataRecords(appended,self.metafile_data)
        self.output_data = combine_multiple_records.get_output_data()
        self.output_data = self.give_values_after_multiple_files_transform(one_file)
        self.get_gender()
        self.check_validity_of_votings()
        self.check_procedurality_of_votings()
        output = Output()
        output.dump_output_file(self.metafile_data['config']['output_file'] if self.metafile_data['config'].get('output_file') is not None else 'out.json',self.output_data)
        print("INFO: OK")

