/** @file config.h
* Hlavickovy soubor k config.cpp
* @author Radek Hranicky
*/

/*
LIS Noise Cleaner - Tento nastroj slouzi k filtraci sumu vytvoreneho programem LDP
Copyright (C) 2012 Radek Hranicky

Tento program je svobodny software: muzete jej sirit a upravovat podle ustanoveni Obecne verejne licence GNU (GNU General Public License),
vydavane Free Software Foundation a to bud podle 3. verze teto Licence, nebo (podle vaseho uvazeni) kterekoli pozdejsi verze.

Tento program je rozsirovan v nadeji, ze bude uzitecny, avas BEZ JAKEKOLIV ZARUKY. Neposkytuji se ani odvozene zaruky PRODEJNOSTI
anebo VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v Obecne verejne licenci GNU.

Kopii Obecne verejne licence GNU jste meli obdrzet spolu s timto programem. Pokud se tak nestalo, najdete ji zde: <http://www.gnu.org/licenses/>.
*/

#ifndef CONFIG_H
#define CONFIG_H

#include <list>
#include <pcap.h>
#include <arpa/inet.h>

using namespace std;

typedef struct packetInfo {
  uint16_t pktType;              // typ paketu (ether_type)
  in_addr ipv4_srcAddr;        // zdrojova IPv4 adresa
  in_addr ipv4_dstAddr;        // cilova IPv4 adresa
  struct in6_addr ipv6_srcAddr; // zdrojova IPv6 adresa
  struct in6_addr ipv6_dstAddr; // cilova IPv6 adresa
  uint16_t srcPort;             // zdrojovy TCP port
  uint16_t dstPort;             // cilovy TCP port
  uint32_t seqNum;              // TCP sekvencni cislo
  uint8_t hopLimit;             // Hop Limit IPv6 datagramu
  uint16_t tcpPayload;          // delka TCP dat
  unsigned char secretByte;     // znak zpravy ulozeny v paketu
} TpacketInfo;

typedef struct sConfig {
  /* konfigurace programu */
  string input_file;                    // nazev vstupniho souboru
  string output_file;                   // nazev vystupniho souboru

  /* stav programu */
  pcap_t *pcapHandler;                  // pcap handler
  pcap_dumper_t *pcapDump;              // pcap handler vystupniho souboru
  char pcapErrbuf[PCAP_ERRBUF_SIZE];    // pcap error buffer
  list<TpacketInfo> selected_packets;   // vybrane pakety (kolizni TCP segmenty s nejvyssim hop limitem)

  /* statistiky */
  unsigned long int pktCount;           // pocet zpracovanych paketu
  unsigned long int tcpCount;           // pocet zpracovanych TCP segmentu
  unsigned long int byteTcpCount;       // pocet jednobytovych TCP segmentu
  unsigned long int pktWrittenCount;    // pocet paketu zapsanych na vystup
} TConfig;

void initConfig(TConfig &cfg);

#endif
