/** @file tcp.cpp
* zdrojovy soubor s implementaci vypoctu TCP checksumu pro IPv6
* @author Radek Hranicky
*/

/*
LIS Deception Proxy - Tento nastroj slouzi pro demonstraci utoku na system pro zakonne odposlechy
Copyright (C) 2012 Radek Hranicky

Tento program je svobodny software: muzete jej sirit a upravovat podle ustanoveni Obecne verejne licence GNU (GNU General Public License),
vydavane Free Software Foundation a to bud podle 3. verze teto Licence, nebo (podle vaseho uvazeni) kterekoli pozdejsi verze.

Tento program je rozsirovan v nadeji, ze bude uzitecny, avas BEZ JAKEKOLIV ZARUKY. Neposkytuji se ani odvozene zaruky PRODEJNOSTI
anebo VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v Obecne verejne licenci GNU.

Kopii Obecne verejne licence GNU jste meli obdrzet spolu s timto programem. Pokud se tak nestalo, najdete ji zde: <http://www.gnu.org/licenses/>.
*/

#include <iostream>

#include <netinet/ip6.h>
#include <netinet/tcp.h>

#include "tcp.h"

/**
 * Vypocet a ulozeni TCP kontrolniho souctu pro IPv6
 * @param IPv6 header
 * @param TCP header
 * @param delka TCP segmentu
 */
void tcpChecksum_for_ipv6(struct ip6_hdr *ipv6_header, struct tcphdr *tcp_header, unsigned int tcp_segmentLen) {
  tcp_header->check = htons(0); // nastavime TCP checksum na nulu

  uint32_t tcpLen_and_nextHeader[2];
	uint32_t sum = 0;
	uint16_t sum16;
  uint16_t *tcp_segment; // 16bitovy ukazatel na TCP segment

  tcp_segment = (uint16_t *)tcp_header;
  //tcp_segment[tcp_segmentLen] = 0; // aplikujeme "vycpavku"

  /* nejprve provedeme soucet z pseudo-hlavicky IPv6 */
	sum += uint16_checksum((uint16_t *)(void *)&ipv6_header->ip6_src, 16);
	sum += uint16_checksum((uint16_t *)(void *)&ipv6_header->ip6_dst, 16);
	tcpLen_and_nextHeader[0] = htonl(tcp_segmentLen);
	tcpLen_and_nextHeader[1] = htonl(ipv6_header->ip6_nxt);
	sum += uint16_checksum((uint16_t *)tcpLen_and_nextHeader, 8);

  /* a pote samotneho TCP segmentu */
	sum += uint16_checksum(tcp_segment, tcp_segmentLen);

	// vypocet jednickoveho doplnku a prevod na 16bitovou reprezentaci
	sum = (sum & 0xFFFF) + (sum >> 16);
	sum = (sum & 0xFFFF) + (sum >> 16);
	sum16 = htons(sum);
	sum16 = ~sum16;

	if (sum16 == 0) {
		sum16 = 0xFFFF;
	}
	tcp_header->check = sum16; // ulozime vypocitany checksum
}


/**
 * Kontrolni soucet dvojic 16bitovych dat
 * @param 16bitova data
 * @param delka
 * @return vysledek
 */
uint32_t uint16_checksum(uint16_t *data, size_t n)
{
	uint32_t sum=0;
	while (n>=2) {
		sum += (uint32_t)ntohs(*data);
		data++;
		n -= 2;
	}
	if (n == 1) {
		sum += (uint32_t)ntohs(*(uint8_t *)data);
	}
	return sum;
}
