/** @file noise.cpp
* Zdrojovy soubor s implementaci generovani nahodnych znaku a cteni podvrzene zpravy
* @author Radek Hranicky
*/

/*
LIS Deception Proxy - Tento nastroj slouzi pro demonstraci utoku na system pro zakonne odposlechy
Copyright (C) 2012 Radek Hranicky

Tento program je svobodny software: muzete jej sirit a upravovat podle ustanoveni Obecne verejne licence GNU (GNU General Public License),
vydavane Free Software Foundation a to bud podle 3. verze teto Licence, nebo (podle vaseho uvazeni) kterekoli pozdejsi verze.

Tento program je rozsirovan v nadeji, ze bude uzitecny, avas BEZ JAKEKOLIV ZARUKY. Neposkytuji se ani odvozene zaruky PRODEJNOSTI
anebo VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v Obecne verejne licenci GNU.

Kopii Obecne verejne licence GNU jste meli obdrzet spolu s timto programem. Pokud se tak nestalo, najdete ji zde: <http://www.gnu.org/licenses/>.
*/

#include <iostream>
#include <cstdlib>
#include <arpa/inet.h>
#include <math.h>

#include "noise.h"

/**
 * Vygeneruje nahodny znak
 * @return znak
 */
unsigned char randomChar() {
  unsigned char c;
  c = (unsigned char)(rand() % ('z' - '0' + 1) + '0');
  return c;
}

/**
 * Vygenerovani nahodneho Hop Limitu pro datagram
 * @param maximum
 * @return hodnota Hop Limit
 */
uint8_t genNoiseHlim(uint8_t max) {
  if (max == 0) {
    return 0;
  }
  double x = 0.0;
  double y = 0.0;

  do {
    x = randomDouble(0, max);
    y = randomDouble(0, 2.0/max);
  } while (y > f(x, max));

  return (uint8_t)(ceil(x));
}

/**
 * Funkce hustoty pravdepodobnosti pro generator Hop Limitu
 * @param hodnota
 * @param maximum
 * @return pravdepodobnost
 */
double f(double x, double max) {
  if (max == 0) {
    return 0;
  }
  return (2.0 * x) / (max * max);
}

/**
 * Vygenerovani nahodneho celeho cisla v urcitem rozsahu
 * @param minimum
 * @param maximum
 * @return cislo
 */
uint8_t randomUint(uint8_t min, uint8_t max)
{
  return rand() % (max - min + 1) + min;
}

/**
 * Vygenerovani nahodneho cisla typu double v urcitem rozsahu
 * @param minimum
 * @param maximum
 * @return cislo
 */
double randomDouble(double min, double max)
{
  return uniRand() * (max - min) + min;
}


/**
 * Vygenerovani nahodneho cisla mezi 0 a 1
 * @return cislo
 */
double uniRand()
{
  return rand() / double(RAND_MAX);
}

