#include <stdio.h>
#include <stdlib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>

#include "BUT_Caretaker_Trajectory.h"

#define CONFIG_FILE "config.xml"
#define EXAMPLE_DATA1 "./exampleData/000000"
#define EXAMPLE_DATA2 "./exampleData/000003"
#define EXAMPLE_DATA3 "./exampleData/000000.2d"

#define INPUT_WIDTH 4 // count(x,y,dx,dy)

/**
  * Function which loads trajectory from file
  * @param filename
  * @param trajectory - pointer to array with coordinates (function alocates memory)
  * @param len - here is returned lenght of trajectory (count of coordintes)
  */

void loadTrajectoryWithAlloc(const char* filename, float** trajectory, int* len) {
  FILE *fp = fopen(filename, "r");
  fscanf(fp, "%d", len);
  float *t = (float*)malloc ( sizeof(float) * INPUT_WIDTH * (*len) );
  for (int i = 0; i < (*len) * INPUT_WIDTH; i++) {
    fscanf(fp, "%f", &t[i]);
  }
  fclose(fp);
  *trajectory = t;
}

int main (int argc, char** argv) {

  xmlDoc* cfgXmlDoc = xmlReadFile(CONFIG_FILE, NULL, 0);
  if (!cfgXmlDoc) {
    fprintf(stderr, "config file \"%s\" not exists\n", CONFIG_FILE);
    return 1;
  }

//// Resources allocation
  struct TrajectoryClassifier* c;

  float* trajectory = NULL;
  int trajectoryLen;
  int trajectoryClass = -1;
  float likelyhood;

  c = trajectoryClassifierCreate ( xmlDocGetRootElement(cfgXmlDoc), "camera_3" );
//  c = trajectoryClassifierCreate ( xmlDocGetRootElement(cfgXmlDoc) , NULL);
  

////////////////////////////////////////////////////////////////////////////////
// (1)
#if 0
  loadTrajectoryWithAlloc(EXAMPLE_DATA1, &trajectory, &trajectoryLen); // obtaining of trajectories from file
  
//// trajectory classification (whole trajectory)
  trajectoryProcess(c, trajectory, trajectoryLen, &trajectoryClass, &likelyhood);  
  printf("winner model is \"%d\" with likelyhood \"%f\"\n", trajectoryClass, likelyhood);  
  
//  printTrajectoryClassifierInfo(c);
  
  free(trajectory); 
#endif
////////////////////////////////////////////////////////////////////////////////
// (2)
#if 0
  loadTrajectoryWithAlloc(EXAMPLE_DATA2, &trajectory, &trajectoryLen); // obtaining of trajectories

  trajectoryClear( c ); // removing old trajectories from memory
  
// trajectory classification (in parts)
  float* coords;
  for (int i = 0; i < trajectoryLen; i++) {
    coords = trajectory + INPUT_WIDTH * i;
    trajectoryAddCoords( c, coords );
//    printf("%f %f %f %f\n", coords[0], coords[1], coords[2], coords[3]);    
  }

  trajectoryEvaluate( c, &trajectoryClass, &likelyhood );
  printf("winner model is \"%d\" with likelyhood \"%f\"\n", trajectoryClass, likelyhood);  

  free(trajectory);  
#endif
////////////////////////////////////////////////////////////////////////////////
// (2)
#if 1

  float *trajectory4d;
  loadTrajectoryWithAlloc(EXAMPLE_DATA3, &trajectory, &trajectoryLen); // obtaining of trajectories from file
  convert2Dto4DWithAlloc (trajectory, &trajectory4d, trajectoryLen);
  free(trajectory); 
  
//// trajectory classification (whole trajectory)
  trajectoryProcess(c, trajectory4d, trajectoryLen, &trajectoryClass, &likelyhood);  
  printf("winner model is \"%d\" with likelyhood \"%f\"\n", trajectoryClass, likelyhood);  
  
//  printTrajectoryClassifierInfo(c);
  free(trajectory4d); 
  

#endif
////////////////////////////////////////////////////////////////////////////////

//// resource deallocation
  trajectoryClassifierRelease( &c );
  xmlFreeDoc(cfgXmlDoc);

  return 0;
}
