/* pivo passing implementation of Viterbi - very simple and not optimized */

#include <stdio.h>
#include <math.h>
#include "viterbi_pivo.h"
#include "common.h"
#include "lukas.h"

/**
  * Funkce pro vypocet viterbiho pravdepodobnosti
  *
  * @return viterbiho pravdepodobnost pruchodu danym modelem
  * // jmeno parametru     Popis parametru      ( defaultni hodnoty v ukazkovem priklade )
  * @param N       pocet stavu modelu                              ( 7 == 5 + 2 okrajove )
  * @param P       velikost feature vektoru                        ( 39 formantu )
  * @param means   mi - stredni hodnota gausovky pro dany stav hmm ( N x P == 7 x 39 )
  * @param vars    sigma - rozptyl gausovky pro dany stav hmm      ( N x P == 7 x 39 )
  * @param trans   prechodova funkce markovova modelu              ( N x N == 7 x 7 )
  * @param fea     feature vector                                  ( P x T == 39 form. x 45 casu )
  * @param T       velikost feature vektoru                        ( 45 casovych jednotek )
  */

float viterbi (int N, int P, float **means, float **vars, float **trans,
	       float **fea, int T) {

  float *this, *next, a, token;
//  float b
  int i, j, from, t; 
//  int to;

  this = Alloc_1_Float (N);  /* buffer with current tokens */
  next = Alloc_1_Float (N);  /* buffer with NEXT tokens */

  /* initialize the algorithm - inserting token in first all 
     entry states - means the 1st state */

  for (i=0; i<N; i++) {

    this[i] = next[i] = MINUS_INFTY;

  }

  this[0] = 0; 

  float likelyhood;


//  float LogGaussPDF(float *observation, float *means, float *variances, int size)

  /* run Viterbi - propagate tokens - for all times.  */

  for (t = 0; t < T; t++) { // projde vsechy casy feature vektoru

    for (i = 0; i < N; i++) { // projde vsecky stavy v soucasnem case

      for (j = 0; j < N; j++) { // projde vsecky stavy v nasledujicim case

        if ( (trans[i][j] != 0.0f) ) { // prechodova pravdepodobnost != 0

          likelyhood = 
            // viterbiho pravdepodobnost z predchoziho stavu
            this[i]
            + (
              // vysilaci pravdepodobnost
              LogGaussPDF(fea[t], means[j], vars[j], P)
              // prechodova pravdepodobnost
              + log(trans[i][j])
            );          
          // prirazeni maximalniho likelyhoodu
          next[j] = fmaxf(likelyhood, next[j]);


        } // endif (trans[i][j] != 0.0f)

      } // endfor(j: 0-N)

   } // endfor(i: 0-N)

    /* token passing for one time 't' is ready, next becomes this */

    for (i=0; i<N; i++) {

      this[i] = next[i]; 
      next[i] = MINUS_INFTY;

    }

  } /* end for all times */
  
  /* finish the Viterbi - see what is connected to exit state and add just 
     the transition proba */
  next[N-1] = MINUS_INFTY;
  for (from=1; from < N-1; from++) { 

    token = this[from]; 
    if (token == MINUS_INFTY) {
      continue; /* no token */
    }

    a = trans[from][N-1];

    if (a == 0.0) {
      continue;  /* no transition */ 
    }

    token += log(a);  /* only trans proba, no emission */

    if (token > next[N-1]) {
      next[N-1] = token;
    }

  }

  return next[N-1];
}
    
