/*  viterbi.c */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "lukas.h"
#include "common.h"
#include "viterbi_pivo.h"


/**
  * Function which loads trajectory from file
  * @param filename
  * @param trajectory - pointer to array with coordinates (function alocates memory)
  * @param len - here is returned lenght of trajectory (count of coordintes)
  */
	  
void loadTrajectoryWithAlloc(const char* filename, float*** trajectory, int* len, const int input_width) {
  FILE *fp = fopen(filename, "r");

  fscanf(fp, "%d", len);
  float **t = Alloc_2_Float (*len, input_width);

  for (int i = 0; i < (*len); i++) {
    for (int j = 0; j < input_width; j++) {
      fscanf(fp, "%f", &t[i][j]);
    }
  }
  
  fclose(fp);
  *trajectory = t;
}
			    

/* main */
int main(int argc, char **argv) {

  char *nmodel, *nfea; 
  FILE *fmodel; 
  float **means, **vars, **fea, **a; 
  int N, P;                         /* no of states, no of features */
  int T;                            /* number of vectors */
  int state,i; 
  float Pstar;                      /* log viterbi proba */
  
  
  if (argc != 3) {
    fprintf(stderr, "usage: viterbi model feature_file\n");
    exit(-1);
  }

  nmodel = argv[1]; 
  nfea = argv[2]; 

  /********** reading model ************/
  /* open model, allocate and read it */
  fmodel = File_Open(nmodel, "rb", "viterbi");
  fscanf(fmodel, "%d", &N); 
  /* ja ale chci skutecne 7 ! */
  N += 2; 

  /* velikost features */  
  fscanf(fmodel, "%d", &P); 
  //pLs ("N",N); 
  //pLs ("P",P); 

  /* alokace po model */
  means = Alloc_2_Float (N,P);
  vars = Alloc_2_Float (N,P);
  a = Alloc_2_Float (N,N);

  /* means a vars pro 1 a posledni stav budou nuly, do zbytku nacist  */
  for (i=0; i<P; i++) {

    means[0][i] = means[N-1][i] = vars[0][i] = vars[N-1][i] = 0.0; 

  }

  //printf("zeros ok"); fflush(stdout);

  for (state=1; state<=N-2; state++) {
    for (i=0; i<P; i++) {

      fscanf(fmodel, "%f", &means[state][i]);

    }
  }

  //printf("means ok"); fflush(stdout);

  for (state=1; state<=N-2; state++) {
    for (i=0; i<P; i++) {

      fscanf(fmodel, "%f", &vars[state][i]);

    }
  }

  //printf("vars ok"); fflush(stdout);
  /* transition probas */
  for (state=0; state<N; state++) {
    for (i=0; i<N; i++) {

      fscanf(fmodel, "%f", &a[state][i]);

    }
  }

  //printf("trans ok"); fflush(stdout);
  fclose (fmodel);

  /* print it out ... */
//  for (state=0; state<N; state++) pfv ("mean",means[state],P);
//  for (state=0; state<N; state++) pfv ("var",vars[state],P);
//  for (state=0; state<N; state++) pfv ("trans",a[state],N);

  /********* read features ************/

#if 1

  loadTrajectoryWithAlloc(nfea, &fea, &T, P);

#else // reading of HTK feature files

  HTK_Header header;                /* struct. defined in lukas.h */
  FILE *ffea; 

  ffea = File_Open(nfea, "rb", "viterbi");

  if (ReadHTKHeader (ffea, &header, 1)) { // wants swapping 
    ErrorExit ("problem reading header"); 
  }

  if (header.sampSize/4 != P) {
    ErrorExit ("problem feature size"); 
  }
  
  T = header.nSamples;
  fea = Alloc_2_Float (T,P);
  for (i=0; i<T; i++) {

    if (ReadHTKFeature(ffea, fea[i], P, 1)) {
      ErrorExit ("problem reading features"); 
    }
    //pfv("features",fea[i],P);

  }

#endif
  
  /********* run viterbi ! ************/
  Pstar = viterbi (N,P,means,vars,a,fea,T); 
  //  printf ("N=%d P=%d T=%d %f\n",N,P,T,Pstar);
  printf ("%f\n",Pstar);

}
