/* lukas.h */
#include <stdio.h>

typedef struct {
    long  nSamples;              /* Structure for HTK header */
    long  sampPeriod;
    short sampSize;
    short sampKind;
}
HTK_Header;

#define SQR(a) ((a)*(a))
#ifndef M_PI
#define M_PI 3.1415926535897932384626433832795
#endif

#define swap4(a) {int t=((char*)&a)[0]; ((char*)&a)[0]=((char*)&a)[3]; ((char*)&a)[3]=t;\
                      t=((char*)&a)[1]; ((char*)&a)[1]=((char*)&a)[2]; ((char*)&a)[2]=t;}
#define swap2(a) {int t=((char*)&a)[0]; ((char*)&a)[0]=((char*)&a)[1]; ((char*)&a)[1]=t;}

int ReadHTKFeature(FILE *fp_in, float *in, size_t fea_len, int swap); 
int ReadHTKHeader (FILE *fp_in, HTK_Header * header, int Swap); 
float LogGaussPDF(float  *observation, float *means, float *variances, int size); 
