/* lukas.c - davam pryc vsechny definice ! */

#include <stdio.h>
#include <math.h>
#include "lukas.h"

int ReadHTKFeature(FILE * fp_in, float *in, size_t fea_len, int swap)
{
  size_t i;

  if ( fread(in, sizeof (float), fea_len, fp_in) != fea_len) {
    return -1;
  }

  if (swap) {

    for(i = 0; i < fea_len; i++) {
      swap4(in[i]);
    }
  }

  return 0;
}

int ReadHTKHeader (FILE * fp_in, HTK_Header * header, int Swap)
{
  if(!fread(&header->nSamples,   sizeof (long),  1, fp_in)) return 0;
  if(!fread(&header->sampPeriod, sizeof (long),  1, fp_in)) return 0;
  if(!fread(&header->sampSize,   sizeof (short), 1, fp_in)) return 0;
  if(!fread(&header->sampKind,   sizeof (short), 1, fp_in)) return 0;

  if(Swap) {
    swap4(header->nSamples);
    swap4(header->sampPeriod);
    swap2(header->sampSize);
    swap2(header->sampKind);
  }

//printf("%ld %ld %d %d\n", header->nSamples, header->sampPeriod, header->sampSize, header->sampKind);
/*
  if(header->sampPeriod < 0 || header->sampPeriod > 100000 ||
     header->nSamples   < 0 || header->sampSize   < 0) {
    return -1;
  }
*/
  return 0;
}


float LogGaussPDF(float  *observation, float *means, float *variances, int size)
{
  float cov_det = 1, logPdf = 0;
//  float gconst;
  int i;
  

  for(i = 0; i < size; i++) {
    cov_det *= variances[i];
    logPdf += SQR(observation[i] - means[i]) / variances[i];
  }
  logPdf += log(cov_det * pow(2 * M_PI, size));
  return - 0.5 * logPdf;
}
