/**************************************************************************
* header for common.c
***************************************************************************/

#include <stdio.h>

/* printing */

void pnl(void);
void pfs(char *text, float scalar);
void pfv(char *text, float *vector, short size);
void pds(char *text, double scalar);
void pdv(char *text, double *vector, short size);
void psws(char *text, short scalar);
void pswv(char *text, short *vector, short size);
void pLs(char *text, long scalar);
void pLv(char *text, long *vector, short size);
void pswfs(char *text, short scalar, float scale);
void pswfv(char *text, short *vector, short size, float scale);
void pLfs(char *text, long scalar, float scale);
void pLfv(char *text, long *vector, short size, float scale);

/* Error and exit  */

void ErrorExit (char *text);

/* alloc */
float *Alloc_1_Float(long d0);
float **Alloc_2_Float(long d0, long d1);
float ***Alloc_3_Float(long d0, long d1, long d2);
float ****Alloc_4_Float(long d0, long d1, long d2, long d3);

double *Alloc_1_Double(long d0);
double **Alloc_2_Double(long d0, long d1);
double ***Alloc_3_Double(long d0, long d1, long d2);
double ****Alloc_4_Double(long d0, long d1, long d2, long d3);

long *Alloc_1_Long(long d0);
long **Alloc_2_Long(long d0, long d1);
long ***Alloc_3_Long(long d0, long d1, long d2);
long ****Alloc_4_Long(long d0, long d1, long d2, long d3);

int *Alloc_1_Int(int d0);
int **Alloc_2_Int(int d0, int d1);
int ***Alloc_3_Int(int d0, int d1, int d2);
int ****Alloc_4_Int(int d0, int d1, int d2, int d3);

short *Alloc_1_Short(long d0);
short **Alloc_2_Short(long d0, long d1);
short ***Alloc_3_Short(long d0, long d1, long d2);
short ****Alloc_4_Short(long d0, long d1, long d2, long d3);

char *Alloc_1_Char(long d0);
char **Alloc_2_Char(long d0, long d1);
char ***Alloc_3_Char(long d0, long d1, long d2);
char ****Alloc_4_Char(long d0, long d1, long d2, long d3);

/* free */
void Free_1_Float(float *f);
void Free_2_Float(float **f, long d0);
void Free_3_Float(float ***f, long d0, long d1);
void Free_4_Float(float ****f, long d0, long d1, long d2);

void Free_1_Double(double *d);
void Free_2_Double(double  **d, long d0);
void Free_3_Double(double  ***d, long d0, long d1);
void Free_4_Double(double  ****d, long d0, long d1, long d2);

void Free_1_Long(long *f);
void Free_2_Long(long **f, long d0);
void Free_3_Long(long ***f, long d0, long d1);
void Free_4_Long(long ****f, long d0, long d1, long d2);

void Free_1_Int(int *f);
void Free_2_Int(int **f, int d0);
void Free_3_Int(int ***f, int d0, int d1);
void Free_4_Int(int ****f, int d0, int d1, int d2);

void Free_1_Short(short *f);
void Free_2_Short(short **f, long d0);
void Free_3_Short(short ***f, long d0, long d1);
void Free_4_Short(short ****f, long d0, long d1, long d2);

void Free_1_Char(char *f);
void Free_2_Char(char **f, long d0);
void Free_3_Char(char ***f, long d0, long d1);
void Free_4_Char(char ****f, long d0, long d1, long d2);

/* files */
FILE *File_Open (char *name, char *mode, char *begin_of_message);

/* zeroing */
void Zero_1_Float (float*, long);

/* maximum/minimum/mean/sorting  */
float Maximum (float*, short, short*);
float Minimum (float*, short, short*);
float Mean (float *pfV, long L_Len);
float Variance (float *pfV, long L_Len);
float Variance2Pass (float *pfV, long L_Len);
void  Sort (float*, long*, long);

/* swapping shorts */
void SwapShortVector (short*, long);

/* swapping anything */
void SwapVector (char *vector, long noitems, long bytesitem);
void SwapVector4Bytes (char *vector, long noitems);
