/**************************************************************************
* NAME        common.c
* FUNCTION    common functions useful EVERYWHERE
*                functions should be only ADDED, not MODIFIED !!!
* DESCRIPTION object file with common fucntions jan.o will be created,
*              and used with jan.h
* CALL        no call
* AUTHOR      Jan Cernocky
* CREATED     17/7/96
* MODIFIED    7/12/96
*             8/3/98 - Double alloc/free added
* 	      17/3/98 - Sort added
*             25/4/2001 - int alloc/free added
*             8/8/2001  - added swapping of arbitrary vecs. 
*             17/8/2001 - added swapping of 4-byte nos.
*                       - modified Mean so that the length is long and the 
*                         accum is double. 
*                       - added Variance and Variance2Pass 
* TABLE OF CONTENTS:
*   - allocation and liberation of memory with checking Alloc_x_yyy, Free_x_yyy
*   - intelligent file opening with a message File_Open
* ***************************************************************************/
#include <stdio.h>
#include <stdlib.h>   
#include <string.h>
#include <math.h>
#include "common.h"

/*#define DEBUG_SORT*/

/* printing */
/*********************** new line ********************************************/
void pnl(void)				/* prints new line */
{
   printf("\n"); fflush(stdout);
}

/*********************** FLOATS ********************************************/
void pfs(char text[], float scalar)   /* prints float scalar */
{
   printf("%s: %f ", text, scalar); fflush(stdout); 
}

void pfv(char text[], float *vector, short size)   /* prints float vector */
{
   short i;
   printf("%s ", text);
   for (i=0; i<size; i++)
      printf("%7.5f ", vector[i]); 
   printf("\n"); fflush(stdout);
}

/*********************** DOUBLES ********************************************/
void pds(char text[], double scalar)   /* prints double scalar */
{
   printf("%s: %f ", text, scalar); fflush(stdout); 
}

void pdv(char text[], double *vector, short size)   /* prints double vector */
{
   short i;
   printf("%s: ", text);
   for (i=0; i<size; i++)
      printf("%7.5f ", vector[i]); 
   printf("\n"); fflush(stdout);
}


/*********************** SHORTS ********************************************/
void psws(char text[], short scalar)   /* prints short scalar */
{
   printf("%s: %7d ", text, scalar); fflush(stdout);
}

void pswv(char text[], short *vector, short size)   /* prints short vector */
{
   short i;
   printf("%s: ", text);
   for (i=0; i<size; i++)
      printf("%7d ", vector[i]);
   printf("\n"); fflush(stdout);
}

/*********************** LONGS ********************************************/
void pLs(char text[], long scalar)   /* prints short scalar */
{
   printf("%s: %ld ", text, scalar); fflush(stdout);
}

void pLv(char text[], long *vector, short size)   /* prints short vector */
{
   short i;
   printf("%s: ", text);
   for (i=0; i<size; i++)
      printf("%ld ", vector[i]);
   printf("\n"); fflush(stdout);
}

/*********************** SHORTS converted to FLOATS by 32768 ******************/
void pswfs(char text[], short scalar, float scale)   /* prints short scalar conv. to fl*/
{
   printf("%s: %f ", text, (float)scalar/32768.0*scale); fflush(stdout);
}

void pswfv(char text[], short *vector, short size, float scale)   /* prints short vector 
   							conv. to fl.*/
{
   short i;
   printf("%s: ", text);
   for (i=0; i<size; i++)
      printf("%7.3f ", (float)vector[i] / 32768.0 * scale);
   printf("\n"); fflush(stdout);
}

/*********************** LONGS converted to FLOATS by 2147483648 ************/
void pLfs(char text[], long scalar, float scale)   /* prints short scalar conv. to fl*/
{
   printf("%s: %f ", text, (float)scalar/2147483648.0*scale); fflush(stdout);
}

void pLfv(char text[], long *vector, short size, float scale)   /* prints short vector 
   							conv. to fl.*/
{
   short i;
   printf("%s: ", text);
   for (i=0; i<size; i++)
      printf("%7.3f ", (float)vector[i] / 2147483648.0* scale);
   printf("\n"); fflush(stdout);
}


/**************************************************************************
* Error -> good bye the programs !
***************************************************************************/
void ErrorExit (char *text)
{
  fprintf(stderr, "%s\n", text);
  exit(1);
}  


/**************************************************************************
* ALLOCATIONS and LIBERATIONS of memory - with checking 
* Alloc_x_yyy(dim_0, dim_1, ... dim_x-1)
*    where x     - dimension (up to 4)
*          yyy   - variable type (Char, Short, Long, Float)
* Free_x_yyy(pointer, dim_0, dim_1 ... dim_x-2) 
*                       it is not necessary to give the last dimension to 
*                       Free, so that Free_1_yyy will have just one arument
*                          - the pointer.
***************************************************************************/

/***************** allocation of something with checking *********************/
void *Allocate_Something (long hm)   /* how many */
{
   void *ptr;
   if ( (ptr=malloc(hm)) == NULL )
   {
      fprintf(stderr,"\n!!! Problem of allocation of %ld elements - EXITING !!!\n\n",hm);
      fflush(stdout); exit(1);
   }
   return(ptr);
}
/**** FLOAT GROUP **********************************************/
float *Alloc_1_Float(long d0)
{
   float *f;
   f=(float*)Allocate_Something(d0*sizeof(float));  
   return (f);
}
float **Alloc_2_Float(long d0, long d1)
{
   long i;
   float **f;
   f=(float**)Allocate_Something(d0*sizeof(float*));
   for (i=0; i<d0; i++) f[i]=Alloc_1_Float(d1);
   return (f);
}
float ***Alloc_3_Float(long d0, long d1, long d2)
{
   long i;
   float ***f;
   f=(float***)Allocate_Something(d0*sizeof(float**));
   for (i=0; i<d0; i++) f[i]=Alloc_2_Float(d1,d2);
   return (f);
}
float ****Alloc_4_Float(long d0, long d1, long d2, long d3)
{
   long i;
   float ****f;
   f=(float****)Allocate_Something(d0*sizeof(float***));
   for (i=0; i<d0; i++) f[i]=Alloc_3_Float(d1, d2, d3);
   return (f);
}
/**** FREE ***/
void Free_1_Float(float *f)
{
   free (f);
}
void Free_2_Float(float **f, long d0)
{
   long i;
   for (i=0; i<d0; i++) Free_1_Float(f[i]);
   free (f);
}
void Free_3_Float(float ***f, long d0, long d1)
{
   long i;
   for (i=0; i<d0; i++) Free_2_Float(f[i], d1);
   free (f);
}
void Free_4_Float(float ****f, long d0, long d1, long d2)
{
   long i;
   for (i=0; i<d0; i++) Free_3_Float(f[i], d1, d2);
   free (f);
}

/**** DOUBLE GROUP **********************************************/
double *Alloc_1_Double(long d0)
{
   double *f;
   f=(double*)Allocate_Something(d0*sizeof(double));  
   return (f);
}
double **Alloc_2_Double(long d0, long d1)
{
   long i;
   double **f;
   f=(double**)Allocate_Something(d0*sizeof(double*));
   for (i=0; i<d0; i++) f[i]=Alloc_1_Double(d1);
   return (f);
}
double ***Alloc_3_Double(long d0, long d1, long d2)
{
   long i;
   double ***f;
   f=(double***)Allocate_Something(d0*sizeof(double**));
   for (i=0; i<d0; i++) f[i]=Alloc_2_Double(d1,d2);
   return (f);
}
double ****Alloc_4_Double(long d0, long d1, long d2, long d3)
{
   long i;
   double ****f;
   f=(double****)Allocate_Something(d0*sizeof(double***));
   for (i=0; i<d0; i++) f[i]=Alloc_3_Double(d1, d2, d3);
   return (f);
}
/**** FREE ***/
void Free_1_Double(double *f)
{
   free (f);
}
void Free_2_Double(double **f, long d0)
{
   long i;
   for (i=0; i<d0; i++) Free_1_Double(f[i]);
   free (f);
}
void Free_3_Double(double ***f, long d0, long d1)
{
   long i;
   for (i=0; i<d0; i++) Free_2_Double(f[i], d1);
   free (f);
}
void Free_4_Double(double ****f, long d0, long d1, long d2)
{
   long i;
   for (i=0; i<d0; i++) Free_3_Double(f[i], d1, d2);
   free (f);
}
   
/**** LONG GROUP **********************************************/
long *Alloc_1_Long(long d0)
{
   long *f;
   f=(long*)Allocate_Something(d0*sizeof(long));  
   return (f);
}
long **Alloc_2_Long(long d0, long d1)
{
   long i;
   long **f;
   f=(long**)Allocate_Something(d0*sizeof(long*));
   for (i=0; i<d0; i++) f[i]=Alloc_1_Long(d1);
   return (f);
}
long ***Alloc_3_Long(long d0, long d1, long d2)
{
   long i;
   long ***f;
   f=(long***)Allocate_Something(d0*sizeof(long**));
   for (i=0; i<d0; i++) f[i]=Alloc_2_Long(d1,d2);
   return (f);
}
long ****Alloc_4_Long(long d0, long d1, long d2, long d3)
{
   long i;
   long ****f;
   f=(long****)Allocate_Something(d0*sizeof(long***));
   for (i=0; i<d0; i++) f[i]=Alloc_3_Long(d1, d2, d3);
   return (f);
}
/**** FREE ***/
void Free_1_Long(long *f)
{
   free (f);
}
void Free_2_Long(long **f, long d0)
{
   long i;
   for (i=0; i<d0; i++) Free_1_Long(f[i]);
   free (f);
}
void Free_3_Long(long ***f, long d0, long d1)
{
   long i;
   for (i=0; i<d0; i++) Free_2_Long(f[i], d1);
   free (f);
}
void Free_4_Long(long ****f, long d0, long d1, long d2)
{
   long i;
   for (i=0; i<d0; i++) Free_3_Long(f[i], d1, d2);
   free (f);
}
/**** INT GROUP **********************************************/
int *Alloc_1_Int(int d0)
{
   int *f;
   f=(int*)Allocate_Something(d0*sizeof(int));  
   return (f);
}
int **Alloc_2_Int(int d0, int d1)
{
   int i;
   int **f;
   f=(int**)Allocate_Something(d0*sizeof(int*));
   for (i=0; i<d0; i++) f[i]=Alloc_1_Int(d1);
   return (f);
}
int ***Alloc_3_Int(int d0, int d1, int d2)
{
   int i;
   int ***f;
   f=(int***)Allocate_Something(d0*sizeof(int**));
   for (i=0; i<d0; i++) f[i]=Alloc_2_Int(d1,d2);
   return (f);
}
int ****Alloc_4_Int(int d0, int d1, int d2, int d3)
{
   int i;
   int ****f;
   f=(int****)Allocate_Something(d0*sizeof(int***));
   for (i=0; i<d0; i++) f[i]=Alloc_3_Int(d1, d2, d3);
   return (f);
}
/**** FREE ***/
void Free_1_Int(int *f)
{
   free (f);
}
void Free_2_Int(int **f, int d0)
{
   int i;
   for (i=0; i<d0; i++) Free_1_Int(f[i]);
   free (f);
}
void Free_3_Int(int ***f, int d0, int d1)
{
   int i;
   for (i=0; i<d0; i++) Free_2_Int(f[i], d1);
   free (f);
}
void Free_4_Int(int ****f, int d0, int d1, int d2)
{
   int i;
   for (i=0; i<d0; i++) Free_3_Int(f[i], d1, d2);
   free (f);
}
   
/**** SHORT GROUP **********************************************/
short *Alloc_1_Short(long d0)
{
   short *f;
   f=(short*)Allocate_Something(d0*sizeof(short));  
   return (f);
}
short **Alloc_2_Short(long d0, long d1)
{
   long i;
   short **f;
   f=(short**)Allocate_Something(d0*sizeof(short*));
   for (i=0; i<d0; i++) f[i]=Alloc_1_Short(d1);
   return (f);
}
short ***Alloc_3_Short(long d0, long d1, long d2)
{
   long i;
   short ***f;
   f=(short***)Allocate_Something(d0*sizeof(short**));
   for (i=0; i<d0; i++) f[i]=Alloc_2_Short(d1,d2);
   return (f);
}
short ****Alloc_4_Short(long d0, long d1, long d2, long d3)
{
   long i;
   short ****f;
   f=(short****)Allocate_Something(d0*sizeof(short***));
   for (i=0; i<d0; i++) f[i]=Alloc_3_Short(d1, d2, d3);
   return (f);
}
/**** FREE ***/
void Free_1_Short(short *f)
{
   free (f);
}
void Free_2_Short(short **f, long d0)
{
   long i;
   for (i=0; i<d0; i++) Free_1_Short(f[i]);
   free (f);
}
void Free_3_Short(short ***f, long d0, long d1)
{
   long i;
   for (i=0; i<d0; i++) Free_2_Short(f[i], d1);
   free (f);
}
void Free_4_Short(short ****f, long d0, long d1, long d2)
{
   long i;
   for (i=0; i<d0; i++) Free_3_Short(f[i], d1, d2);
   free (f);
}
   
/**** CHAR GROUP **********************************************/
char *Alloc_1_Char(long d0)
{
   char *f;
   f=(char*)Allocate_Something(d0*sizeof(char));  
   return (f);
}
char **Alloc_2_Char(long d0, long d1)
{
   long i;
   char **f;
   f=(char**)Allocate_Something(d0*sizeof(char*));
   for (i=0; i<d0; i++) f[i]=Alloc_1_Char(d1);
   return (f);
}
char ***Alloc_3_Char(long d0, long d1, long d2)
{
   long i;
   char ***f;
   f=(char***)Allocate_Something(d0*sizeof(char**));
   for (i=0; i<d0; i++) f[i]=Alloc_2_Char(d1,d2);
   return (f);
}
char ****Alloc_4_Char(long d0, long d1, long d2, long d3)
{
   long i;
   char ****f;
   f=(char****)Allocate_Something(d0*sizeof(char***));
   for (i=0; i<d0; i++) f[i]=Alloc_3_Char(d1, d2, d3);
   return (f);
}
/**** FREE ***/
void Free_1_Char(char *f)
{
   free (f);
}
void Free_2_Char(char **f, long d0)
{
   long i;
   for (i=0; i<d0; i++) Free_1_Char(f[i]);
   free (f);
}
void Free_3_Char(char ***f, long d0, long d1)
{
   long i;
   for (i=0; i<d0; i++) Free_2_Char(f[i], d1);
   free (f);
}
void Free_4_Char(char ****f, long d0, long d1, long d2)
{
   long i;
   for (i=0; i<d0; i++) Free_3_Char(f[i], d1, d2);
   free (f);
}
   
/*************** intelligent file opening with a message *****************/
FILE *File_Open (char *name, char *mode, char *begin_of_message)
{
   static FILE *fich;
   static char message[256];
   
   fich = fopen(name, mode);
   if (fich != NULL)
     return (fich);            /* o.k. */
   else
   {
      strcpy (message, begin_of_message);
      strcat (message, ": Opening of file "); strcat (message, name);
      strcat (message, " in mode -"); strcat (message, mode);
      strcat (message, "- failed - EXITING !!!\n\n");
      printf ("%s", message); fflush (stdout); exit (1);
      return (NULL); 	/* the prog. will never reach this point */
   }   
}

/***************** filling with zeros *************************************/
void Zero_1_Float (float *a, long length)
{
   long i;
   
   for (i=0; i<length; i++) a[i] = 0.0;
}

/************************ maximum *****************************************/
float Maximum (float *pfV, short swLen, short *swIndexMax)
{
   float fMax;
   short i, swImax;
   
   fMax=pfV[0]; swImax=0;
   for (i=1; i<swLen; i++) {
      if (pfV[i] > fMax) {
	 fMax=pfV[i];
	 swImax=i;
      }
   }
   *swIndexMax = swImax;
   return (fMax);
}
/************************ maximum *****************************************/
float Minimum (float *pfV, short swLen, short *swIndexMin)
{
   float fMin;
   short i, swImin;
   
   fMin=pfV[0]; swImin=0;
   for (i=1; i<swLen; i++) {
      if (pfV[i] < fMin) {
	 fMin=pfV[i];
	 swImin=i;
      }
   }
   *swIndexMin = swImin;
   return (fMin);
}
/************************ mean and var stuff *******************************/
float Mean (float *pfV, long L_Len)
{
   double dSum; float fMean;
   long i;
   
   dSum=0.0;
   for (i=0; i<L_Len; i++) 
      dSum += (double)pfV[i];
   fMean = (float)(L_Len > 0 ? dSum / (double)L_Len : 0.0);
   return (fMean);
}

/* 1 - pass variance - can have numerical problems and return negative value */
float Variance (float *pfV, long L_Len)
{
   double dSum, dSum2, dMean, dMean2, d; float fVar;
   long i;
   
   dSum=dSum2=0.0;
   for (i=0; i<L_Len; i++) {
     d = (double)pfV[i];
     dSum += d;
     dSum2 += d*d;
   }
   if (L_Len == 0) return (0.0);
   dMean = dSum / (double)L_Len; 
   dMean2 = dSum2 / (double)L_Len; 
   fVar = (float)(dMean2 - dMean*dMean);
   return (fVar);
}

/* 2 - pass variance - should be stable */
float Variance2Pass (float *pfV, long L_Len)
{
   double dSum, dMean, d; float fVar;
// double dSum2, dMean2;
   long i;
   
   if (L_Len == 0) return (0.0);
   dSum=0.0;
   for (i=0; i<L_Len; i++) {
     d = (double)pfV[i];
     dSum += d;
   }
   dMean = dSum / (double)L_Len; 

   dSum=0.0;
   for (i=0; i<L_Len; i++) {
     d = ((double)pfV[i] - dMean); 
     dSum += d * d;
   }
   fVar = (float)(dSum / (double)L_Len); 
   return (fVar);
}

/************** sort *****************************************************/
/* perform a "bubble sorting" of a vector of floats. If the pointer of
*  longs  is non-null, supposes, that it is a vector of indices to match
*  the order of floats in the resulting vector. If it is NULL, does nothing
*  with it (no allocation)
**************************************************************************/
void Sort(float *f, long  *indl, long  len)
{
   long i;
//   long j;
   long nb_chg,nb_iter; /* nombre de changements effectues */
   long help_long;
   float help_float;
   
   nb_chg=1;            /* !=1 => cycle passe */
   nb_iter=0;   /* pour le controle */
#ifdef DEBUG_SORT
   pfv ( "sort", f, len);
#endif   
   while(nb_chg != 0)
   {
      nb_iter++;
      nb_chg=0;
      for(i=0; i < len-1; i++)
       if(f[i] < f[i+1])
       {
          nb_chg++;
          
          help_float=f[i];
          f[i]=f[i+1];
          f[i+1]=help_float;
	  
	  if (indl != NULL)  {   /* if wanted, reorganize indices */
	     help_long=indl[i];
	     indl[i]=indl[i+1];
	     indl[i+1]=help_long;
	  }
       }
#ifdef DEBUG_SORT
   printf("sort: len=%ld iter=%d, nb_chg=%ld\n", len, nb_iter, nb_chg);
#endif

   }
#ifdef DEBUG_SORT   
   printf("Sort of %ld items ready in %ld iterations.\n", len ,nb_iter);
#endif   
}

/************************ swap vector of shorts ****************************/
void SwapShortVector (short *s, long n)
{
   char *ch, chaux;
   long i;
   
   ch=(char*)s;
   for (i=0; i<n; i++)  {
      chaux = *ch;
      *(ch++)=*(ch+1);
      *(ch++)=chaux;
   }
}

/* swapping of a vector of data (the function must get *char, so do some cast
   for int and float */
void SwapVector (char *vector, long noitems, long bytesitem) {
   
   char *item,*a,*b;
   int halfbytes,i,j;
//   int k;
   char aux;
   
   halfbytes = bytesitem / 2;   /* integer division */
   item = vector;               /* set pointer to 1st item */
   for (i=0; i<noitems; i++)  {
      a=item; b=item+bytesitem-1;   /* beg and end of item */
      for (j=0; j<halfbytes; j++)  {
         aux=*a;
         *a=*b;
         *b=aux;
         a++;
         b--;
      }
      item += bytesitem;   /* move to next item */
   }
}

/* swapping of a vector of data containing 4-byte numbers (ints or floats)
  (the function must get *char, so do some cast for int and float */
void SwapVector4Bytes (char *vector, long noitems) {
   
   char *item; 
   int i;
   char aux;
   
   item = vector;               /* set pointer to 1st item */
   for (i=0; i<noitems; i++)  {
     aux=item[0]; item[0] = item[3]; item[3] = aux;
     aux=item[1]; item[1] = item[2]; item[2] = aux;
     item += 4;   /* move to next item */
   }
}

