#ifndef BUT_CARETAKER_TRAJECTORY__H
#define BUT_CARETAKER_TRAJECTORY__H

#include <stdio.h>

#include <libxml/parser.h>
#include <libxml/tree.h>

#ifdef __cplusplus
extern "C" {
#endif

struct trajectoryModel {
  int N;
  int P;
  float** means;
  float** vars;
  float** a; 
  
  float threshold;
  char* name;
};

struct TrajectoryClassifier {
  int P;
  int modelCount;

  float **trajectory;
  int trajectoryLen;
  int trajectoryAlloc;

  struct trajectoryModel* models;  
  float *likelyhoods;
};


struct TrajectoryClassifier* trajectoryClassifierCreate ( xmlNode *root, char* scenario );
void trajectoryClassifierRelease( struct TrajectoryClassifier** c);
void trajectoryProcess( struct TrajectoryClassifier* c, const float* trajectory, const int trajectoryLen, int* trajectoryClass, float* likelyhood);
void trajectoryClear( struct TrajectoryClassifier* c );

// functions for sequencial processing
struct TrajectoryClassifier* trajectoryClassifierClone (struct TrajectoryClassifier* c1);
void trajectoryAddCoords( struct TrajectoryClassifier* c, const float* coords );
void trajectoryEvaluate( const struct TrajectoryClassifier* c, int* trajectoryclass, float* likelyhoods);
void printTrajectoryClassifierInfo(const struct TrajectoryClassifier* c);

void convert2Dto4DWithAlloc (float * in, float **out, const int rowCount);


#ifdef __cplusplus
}
#endif

#endif // BUT_CARETAKER_TRAJECTORY__H

