Use the C89 standard, no compiler extensions.

Use the UNIX-style line endings (line feed character, escape sequence `\n`).

The limit on the length of lines is 80 characters (including the `\n`
character).

Use only TAB characters to indent. TABs are 8 characters wide (set TAB stops
at 8 characters).

Do not put multiple statements on a single line.

Use Egyptian brackets (also known as the K&R style) for statement blocks
inside a function. Functions have their opening brace at the next line on the
same indentation level as its header.

Use a space after keywords, except the `sizeof`. Do not add spaces around
(inside) parenthesized expressions. Use one space around (on each side of)
binary and ternary operators. Use no space after prefix, before postfix unary
operators, and around the `.` and `->` operators.

Do not use typedefs for structures.

Use only lowercase English words (or their abbreviations) for identifiers and
underscores as word separators.

Write the comments in a program in English.
