
# Brno Transit System Analysis Tool
Tento repozitár obsahuje kompletnú implementáciu diplomovej práce Analýza a vizualizace dat hromadné dopravy města Brna.

This repository contains the complete implementation of the diploma thesis Analysis and Visualisation of Brno Public Transport Data.

## Autor

Juraj Lazúr, xlazur00, FIT VUT
xlazur00@stud.fit.vutbr.cz

## Podrobné informácie

### Názov práce

 Analýza a vizualizace dat hromadné dopravy města Brna

### Kľúčové slová

dáta, vizualizácia, hromadná doprava, GTFS, routing, spracovanie dát

### Abstrakt

Plánovanie a správa moderných systémov hromadnej dopravy si vyžaduje znalosť správania systémov v reálnom prostredí. Cieľom tejto práce je zjednodušenie postupu získavania užitočných znalostí z dát o meškaní vozidiel v systéme hromadnej dopravy mesta Brna. Riešenie problému spočívalo v návrhu a implementácií nástroja, ktorý bude tieto dáta autonómne spracovávať a analyzovať. Výstupy generované implementovaným nástrojom poskytujú podporu pri plánovaní, implementácií a vyhodnocovaní zmien v systéme hromadnej dopravy. Zároveň umožňujú detekciu kritických miest a opakujúcich sa vzorov v systéme. Výsledky tejto práce umožňujú zefektívniť fungovanie systému hromadnej dopravy a majú slúžiť k zvyšovaniu spokojnosti cestujúcej verejnosti.

## Information

### Title

Analysis and Visualisation of Brno Public Transport Data

### Keywords

data, visualisation, public transit, GTFS, routing, data processing

### Abstract

The planning and management of modern public transport systems requires knowledge of the behaviour of the systems in a real environment. The aim of this thesis is to simplify the procedure of extracting useful knowledge from vehicle delay data in the public transport system of the city of Brno. The solution to the problem consisted in the design and implementation of a tool that will autonomously process and analyze this data. The outputs generated by the implemented tool provide support for planning, implementation and evaluation of changes in the public transport system. They also allow the detection of critical points and recurring patterns in the system. The results of this work allow for a more efficient operation of the public transport system and should serve to increase the satisfaction of the travelling public.

## Návod na použitie

Aplikácia autonómne sleduje a zaznamenáva správanie dopravného systému mesta Brna. Po prvotnom spustení prebieha inicializačná procedúra, po ktorej sa v aplikácií nachádza prvotný model dopravného systému. Prvé spracovanie dát nasleduje až nasledujúci deň o 1:15. Toto spracovanie potom prebieha pravidelne každý deň. Spracované dáta je možné vizualizovať a analyzovať pomocou klientskej aplikácie.

## How to use this tool

The application autonomously monitors and records the behaviour of Brno's transport system. After the initial start-up, an initialization procedure takes place, after which the initial model of the transport system is located in the application. The first data processing follows at 1:15 a.m. the next day. This processing then takes place regularly every day. The processed data can be visualised and analysed using the client application.

## Inštalácia a spustenie

### Lokálne spustenie

 1. Inštalácia a spustenie lokálnej MongoDB databázy
 2. V priečinku **backend** spustite `npm install`' a následne `npm start`
 3. V priečinku **frontend** spustite `npm install` a následne `npm start`
 5. Klientska aplikácia by sa mala spustiť na `http://localhost:3000/brno-PTSAT`

### Spustenie s technológiu Docker

    docker-compose up --build

## Install and Run

### Run locally

 1. Install and run local MongoDB
 2. In directory run **backend** `npm install`' and `npm start`
 3. In directory run **frontend** `npm install` and `npm start`
 4. User app should be running on `http://localhost:3000/brno-PTSAT`

### Run with Docker

    docker-compose up --build

## Poznámka k static_files

Nástroj pracuje s mapovými podkladmi mesta Brna. Vzľadom na proprietárnu povahu týchto dát sú v odovzdanom riešení iba ukážky formátu, s ktorým program pracuje. Formát pozostáva z poľa bodov a indexov a susedov, do ktorých je možné z daného bodu prejsť. Aby bolo možné nástroj používať, je nevyhnutné dodať do priečinka príslušné mapové podklady v danom formáte.

## Note on static_files

The tool works with map documents of the city of Brno. Due to the proprietary nature of this data, only samples of the format the program works with are included in the submitted solution. The format consists of an array of points and indices and neighbours that can be navigated to from a given point. In order to be able to use the tool, it is necessary to supply the appropriate map documents in the given format to the folder.