﻿/// <summary>
/// The Ethanol.MalwareSonar.MalwareReport namespace contains classes related to malware reporting functionality.
/// </summary>
namespace Ethanol.MalwareSonar.MalwareReport
{
    using System;
    using System.Text.Json.Serialization;

    /// <summary>
    /// Represents a collection of Indicators of Compromise (IOCs) related to malware detection.
    /// </summary>
    public partial class Iocs
    {
        /// <summary>
        /// Gets or sets the collection of URLs that are associated with the malware.
        /// </summary>
        [JsonPropertyName("urls")]
        public string[]? Urls { get; set; }

        /// <summary>
        /// Gets or sets the collection of domain names that are associated with the malware.
        /// </summary>
        [JsonPropertyName("domains")]
        public string[]? Domains { get; set; }

        /// <summary>
        /// Gets or sets the collection of IP addresses that are associated with the malware.
        /// </summary>
        [JsonPropertyName("ips")]
        public string[]? Ips { get; set; }
    }
}
