﻿namespace Ethanol.MalwareSonar.Fuzzy
{
    /// <summary>
    /// Defines a membership function for fuzzy sets. This interface determines the degree of membership
    /// of an element in the fuzzy set based on its value.
    /// </summary>
    /// <typeparam name="T">The type of elements in the fuzzy set.</typeparam>
    /// <remarks>
    /// A membership function in fuzzy logic is a key concept that assigns to each object
    /// a grade of membership ranging between 0 and 1. These functions are used in fuzzy sets
    /// to indicate the degree of truth as an extension of valuation. This interface allows
    /// for the implementation of various types of membership functions.
    /// </remarks>
    public interface IMembershipFunction<T>
    {
        /// <summary>
        /// Retrieves the membership value of a given element based on the implemented function.
        /// </summary>
        /// <param name="x">The element for which to retrieve the membership value.</param>
        /// <returns>
        /// The membership value of the element. This is typically a value between 0 and 1,
        /// where 0 represents no membership and 1 represents full membership.
        /// </returns>
        double GetMembership(T x);

    }

}
