﻿# DataObjects

In this folder, the POCO representations for different input data is implemented:

* Flowmonexp5Entry -- object representing JSON record created by flowmonexp5 tool. The export is an independned colleciton of JSON objects.
* IpfixcolEntry -- object representing JSON record created by ipfixcol2 tool. The export is NDJSON file.
* NfdumpEntry -- represents a single flow record as exported from nfdump. The export is CSV file.

## Flowmonexp5Entry 

The following is an example JSON for ordinary TCP flow record:

```json
{
	"BYTES":272,
	"BYTES_A":152,
	"BYTES_B":120,
	"CRC":12624162627998215367,
	"END_NSEC":"2022-09-06 10:31:28.172917065",
	"END_NSEC_A":"2022-09-06 10:31:28.151282823",
	"END_NSEC_B":"2022-09-06 10:31:28.172917065",
	"FLAG_FLUSH":5,
	"FLAG_MISC":897,
	"FLOWMON_STARTUP_TIME_NSEC":"2022-09-06 10:29:51.524263430",
	"INPUT_INTERFACE":0,
	"L3_IPV4_DST":"3.125.223.134",
	"L3_IPV4_SRC":"192.168.100.52",
	"L3_PROTO":4,
	"L4_PORT_DST":12305,
	"L4_PORT_SRC":60882,
	"L4_PROTO":6,
	"L4_TCP_FLAGS":"---A-RS-",
	"L4_TCP_FLAGS_A":"------S-",
	"L4_TCP_FLAGS_B":"---A-R--",
	"ONE":1,
	"PACKETS":6,
	"PACKETS_A":3,
	"PACKETS_B":3,
	"QUEUE_ID":0,
	"SAMPLING_ALGORITHM":0,
	"SAMPLING_RATE":0,
	"START_NSEC":"2022-09-06 10:31:27.092077647",
	"START_NSEC_A":"2022-09-06 10:31:27.092077647",
	"START_NSEC_B":"2022-09-06 10:31:27.113884341"
}

```

The following is an example JSON for DNS record:

```json
{
	"BYTES":164,
	"BYTES_A":58,
	"BYTES_B":106,
	"CRC":13514403522362987395,
	"END_NSEC":"2022-09-06 10:29:56.527134316",
	"END_NSEC_A":"2022-09-06 10:29:56.519244268",
	"END_NSEC_B":"2022-09-06 10:29:56.527134316",
	"FLAG_FLUSH":5,
	"FLAG_MISC":913,
	"FLOWMON_STARTUP_TIME_NSEC":"2022-09-06 10:29:51.524263430",
	"INPUT_INTERFACE":0,
	"INVEA_DNS_ADDTREC_COUNT_REQUEST":0,
	"INVEA_DNS_ADDTREC_COUNT_RESPONSE":0,
	"INVEA_DNS_ANSWREC_COUNT_REQUEST":0,
	"INVEA_DNS_ANSWREC_COUNT_RESPONSE":3,
	"INVEA_DNS_AUTHREC_COUNT_REQUEST":0,
	"INVEA_DNS_AUTHREC_COUNT_RESPONSE":0,
	"INVEA_DNS_CRR_CLASS":1,
	"INVEA_DNS_CRR_NAME":"pastebin.com",
	"INVEA_DNS_CRR_RDATA":"104.20.68.143",
	"INVEA_DNS_CRR_RDATA_LEN":4,
	"INVEA_DNS_CRR_TTL":300,
	"INVEA_DNS_CRR_TYPE":1,
	"INVEA_DNS_FLAGS_CODES_REQUEST":256,
	"INVEA_DNS_FLAGS_CODES_RESPONSE":33152,
	"INVEA_DNS_ID":17639,
	"INVEA_DNS_QCLASS":1,
	"INVEA_DNS_QNAME":"pastebin.com",
	"INVEA_DNS_QTYPE":1,
	"INVEA_DNS_QUESTION_COUNT":1,
	"L3_IPV4_DST":"192.168.100.2",
	"L3_IPV4_SRC":"192.168.100.52",
	"L3_PROTO":4,
	"L4_PORT_DST":53,
	"L4_PORT_SRC":57790,
	"L4_PROTO":17,
	"NBAR_APP_ID":50331701,
	"NBAR_NAME":"DNS_TCP",
	"ONE":1,
	"PACKETS":2,
	"PACKETS_A":1,
	"PACKETS_B":1,
	"QUEUE_ID":0,
	"SAMPLING_ALGORITHM":0,
	"SAMPLING_RATE":0,
	"START_NSEC":"2022-09-06 10:29:56.519244268",
	"START_NSEC_A":"2022-09-06 10:29:56.519244268",
	"START_NSEC_B":"2022-09-06 10:29:56.527134316"
}
```

The following is an example for TLS record:

```json
{
	"BYTES":5081,
	"BYTES_A":743,
	"BYTES_B":4338,
	"CRC":16592069638125160219,
	"END_NSEC":"2022-09-06 10:30:00.129894240",
	"END_NSEC_A":"2022-09-06 10:30:00.129894240",
	"END_NSEC_B":"2022-09-06 10:30:00.129872720",
	"FLAG_FLUSH":5,
	"FLAG_MISC":915,
	"FLOWMON_STARTUP_TIME_NSEC":"2022-09-06 10:29:51.524263430",
	"HTTP_METHOD_MASK":512,
	"HTTP_REQUEST_HOST":"pastebin.com",
	"INPUT_INTERFACE":0,
	"L3_IPV4_DST":"104.20.68.143",
	"L3_IPV4_SRC":"192.168.100.52",
	"L3_PROTO":4,
	"L4_PORT_DST":443,
	"L4_PORT_SRC":59591,
	"L4_PROTO":6,
	"L4_TCP_FLAGS":"---APRS-",
	"L4_TCP_FLAGS_A":"---APRS-",
	"L4_TCP_FLAGS_B":"---AP-S-",
	"NBAR_APP_ID":218104261,
	"NBAR_NAME":"SSL/TLS",
	"ONE":1,
	"PACKETS":19,
	"PACKETS_A":9,
	"PACKETS_B":10,
	"QUEUE_ID":0,
	"SAMPLING_ALGORITHM":0,
	"SAMPLING_RATE":0,
	"START_NSEC":"2022-09-06 10:29:56.530491659",
	"START_NSEC_A":"2022-09-06 10:29:56.530491659",
	"START_NSEC_B":"2022-09-06 10:29:56.543384788",
	"TLS_CIPHER_SUITE":49171,
	"TLS_CIPHER_SUITES":"14C013C03900330035002F000AC009C0",
	"TLS_CLIENT_KEY_LENGTH":528,
	"TLS_CLIENT_RANDOM":"6315E657356C6C27770159D65D282CCA7FACDC3231984EE096B825990F996810",
	"TLS_CLIENT_VERSION":769,
	"TLS_CONTENT_TYPE":13,
	"TLS_EC_POINT_FORMATS":"00FFFFFF",
	"TLS_ELLIPTIC_CURVES":"17001800",
	"TLS_EXTENSION_LENGTHS":"11000600020000000100FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF",
	"TLS_EXTENSION_TYPES":"00000A000B00170001FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF",
	"TLS_HANDSHAKE_TYPE":11014,
	"TLS_ISSUER_CN":"Cloudflare Inc RSA CA-2",
	"TLS_JA3_FINGERPRINT":"05AF1F5CA1B87CC9CC9B25185115607D",
	"TLS_PUBLIC_KEY_ALG":6,
	"TLS_PUBLIC_KEY_LENGTH":2048,
	"TLS_SERVER_RANDOM":"6315E657264BFE944BF483EC932D134CF335D75C1DF79F33444F574E47524400",
	"TLS_SERVER_SESSION_ID":"28F20EB640AAB136163081CA127EDA1F908642CFD196B74A379A000DFB7B1AB3",
	"TLS_SERVER_VERSION":769,
	"TLS_SETUP_TIME":78324,
	"TLS_SIGNATURE_ALG":668,
	"TLS_SNI":"pastebin.com",
	"TLS_SNI_LENGTH":12,
	"TLS_SUBJECT_CN":"sni.cloudflaressl.com",
	"TLS_SUBJECT_ON":"Cloudflare, Inc.",
	"TLS_VALIDITY_NOT_AFTER":1686959999,
	"TLS_VALIDITY_NOT_BEFORE":1655337600
}
```
The following is an example for HTTPS record:

```json
{
	"BYTES":2213,
	"BYTES_A":495,
	"BYTES_B":1718,
	"CRC":16592069638125160219,
	"END_NSEC":"2022-09-06 10:30:33.119951747",
	"END_NSEC_A":"2022-09-06 10:30:33.119951747",
	"END_NSEC_B":"2022-09-06 10:30:32.915045673",
	"FLAG_FLUSH":5,
	"FLAG_MISC":899,
	"FLOWMON_STARTUP_TIME_NSEC":"2022-09-06 10:29:51.524263430",
	"INPUT_INTERFACE":0,
	"L3_IPV4_DST":"104.20.68.143",
	"L3_IPV4_SRC":"192.168.100.52",
	"L3_PROTO":4,
	"L4_PORT_DST":443,
	"L4_PORT_SRC":59591,
	"L4_PROTO":6,
	"L4_TCP_FLAGS":"---AP---",
	"L4_TCP_FLAGS_A":"---AP---",
	"L4_TCP_FLAGS_B":"---AP---",
	"NBAR_APP_ID":50332091,
	"NBAR_NAME":"HTTPS",
	"ONE":1,
	"PACKETS":11,
	"PACKETS_A":6,
	"PACKETS_B":5,
	"QUEUE_ID":0,
	"SAMPLING_ALGORITHM":0,
	"SAMPLING_RATE":0,
	"START_NSEC":"2022-09-06 10:30:20.667031377",
	"START_NSEC_A":"2022-09-06 10:30:20.667031377",
	"START_NSEC_B":"2022-09-06 10:30:20.679954789"
}
```
