#!/usr/bin/env python3

"""Tests.py: Class for testing models, in progress"""
__author__      = "Jan Polišenský"


import datetime
import unittest

from classifiers.Lexical import Lexical
from classifiers.Data import Data
from classifiers.SVM import SVM
from resolvers.Geo import Geo
from resolvers.SSL import SSL
from resolvers.Dns_whois import Dns_whois
from classifiers.Net import Net
from classifiers.Aggregator import Aggregator


#######################
### RESOLVERS TESTS ###
#######################

class Geo_test(unittest.TestCase):

    def test_init(self):
        """
        ! Testing module initialization
        """
        geo_resolver = Geo()
        self.assertTrue(isinstance(geo_resolver, Geo))

    def test_error(self):
        geo_resolver = Geo()

        
        data = geo_resolver.resolve("google.com", [])
        self.assertEqual(data['resolver_name'], "geo")
        self.assertEqual(data['success'], True)
        
        self.assertEqual(data['data'][0]['country'], 'CZ',)
        self.assertEqual(data['data'][0]['region'], 'Hlavní město Praha',)
        self.assertEqual(data['data'][0]['city'], 'Prague',)



    def test_wrong_domain(self):
        geo_resolver = Geo()

        
        data = geo_resolver.resolve(int(8), [])

        self.assertEqual(data['success'], False)


class SSL_test(unittest.TestCase):      
     def test_init(self):
        """
        ! Testing module initialization
        """
        ssl_resolver = SSL()
        self.assertTrue(isinstance(ssl_resolver, SSL))

    #  def test_resolve(self):
    #     """
    #     ! Testing module initialization
    #     """
    #     ssl_resolver = SSL()
    #     data = ssl_resolver.resolve("gate.io")
    #     print(data)
    #     input()
    
    
class Dns_whois_test(unittest.TestCase):
    def test_init(self):
        """
        ! Testing module initialization
        """
        dns_resolver = Dns_whois()
        self.assertTrue(isinstance(dns_resolver, Dns_whois))
        
        
    def test_resolve(self):
        """
        ! Testing basic resolve
        """
        dns_resolver = Dns_whois()
        data = dns_resolver.resolve("fit.vutbr.cz", [])
        self.assertEqual(data['success'], True)

#########################
### CLASSIFIERS TESTS ###
#########################

class Data_test(unittest.TestCase):
    pass

class Svm_test(unittest.TestCase):
    pass

class Lexical_test(unittest.TestCase):
    """
    ! Basic tests for lexical model, in progress, should be more comples
    """
     
    
    def test_init(self):
        """
        ! Testing module initialization
        """
        lexical_model = Lexical()
        self.assertTrue(isinstance(lexical_model, Lexical))


    def test_classification(self):
        """
        ! Basic classification test
        """

        lexical_model = Lexical()
            
        data = lexical_model.classify("medikem.cz", [], [])
            
        self.assertEqual(data['classifier_name'], "lexical")
        self.assertEqual(data['final'], False)
        self.assertEqual(data['success'], True)
        self.assertTrue(data['badness'] < 0.1)
        self.assertEqual(type(data['created']), type(datetime.datetime.now()))
            
            
            
    def test_segmentation(self):
        """
        ! Test of domain segmentation
        """
        
        lexical_model = Lexical()
        
        tokens = lexical_model.get_bigrams("google.com")
        
        self.assertEqual(len(tokens), 43)
        self.assertEqual(tokens, [850, 469, 91, 264, 21, 582, 854, 58, 592, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0])


if __name__ == "__main__":
    
    
    # Set test-mode, custom script defined below of runn unittest for all modules
    # WIP 
    unit_test = False
    
    
    
    if unit_test:
        unittest.main()
        exit(0)
        
        
    ### Custom script for testing ###
    
    ssl_resolver = SSL()
    geo_resolver = Geo()
    dns_whois_resolver = Dns_whois()

    domain_name = 'services.flowmon.com'
    ssl_data = ssl_resolver.resolve(domain_name)['data']
    geo_data = geo_resolver.resolve(domain_name, [])['data']
    dns_whois_data = dns_whois_resolver.resolve(domain_name, [])['data']
    

    data_model_req = {"ssl": ssl_data, "geo": geo_data, "dns_whois": dns_whois_data}

    data_model = Data()
    svm_model = SVM()
    lexical = Lexical()
    final = Aggregator()
    


    data_result = data_model.classify(domain_name, [], data_model_req)
    svm_result = svm_model.classify(domain_name, [], data_model_req)
    lexical_result = lexical.classify(domain_name, [], [])
    

    

    
    ### Agregator test ###
    a = final.classify(domain_name, {"data": data_result, "lexical": lexical_result, "svm": svm_result} ,[])
    b = final.classify(domain_name, {"lexical": lexical_result, "svm": svm_result}, [])
    c = final.classify(domain_name, {"data": data_result, "lexical": lexical_result}, [])
    
    
    
    print(a)
    print(b)
    print(c)
    
    # print(data_result, svm_result, lexical_result)





