from sqlalchemy import BigInteger, Column, DateTime, Float, Integer, SmallInteger, Boolean, String, Table, Text, text, JSON, ForeignKey, \
    Numeric, func, LargeBinary, select, and_

from sqlalchemy.sql import expression

from database import db

Base = db.Model


class OffenseSource(Base):
    __tablename__ = 'offense_source'

    id = Column(Integer, primary_key=True, autoincrement=True)
    source_ip = Column(String(255), nullable=False)
    event_flow_count = Column(Integer, nullable=False)
    magnitude = Column(Integer, nullable=False)
    offense_count = Column(Integer, nullable=False)
    time_added = Column(DateTime(timezone=True), nullable=False, server_default=func.now())
    time_updated = Column(DateTime(timezone=True), nullable=False, server_default=func.now(), onupdate=func.now())

class DomainIPMapping(Base):
    __tablename__ = 'domain_ip_mapping'

    id = Column(Integer, primary_key=True, autoincrement=True)
    domain_name = Column(String(255), nullable=False)
    ip_address = Column(Integer, nullable=False)
    time_added = Column(DateTime(timezone=True), nullable=False, server_default=func.now())
    time_updated = Column(DateTime(timezone=True), nullable=False, server_default=func.now(), onupdate=func.now())

class DomainName(Base):
    __tablename__ = 'domain'

    id = Column(Integer, primary_key=True, autoincrement=True)
    domain_name = Column(String(255), nullable=False)
    resolved = Column(Boolean(), nullable=False, server_default=expression.false())
    analyzed = Column(Boolean(), nullable=False, server_default=expression.false())
    result = Column(Text())

class ExternalData(Base):
    __tablename__ = 'external_data'
    id = Column(Integer, primary_key=True, autoincrement=True)
    domain_name = Column(String(255), nullable=False)
    data_type = Column(String(255), nullable=False)
    contents = Column(Text())

# TODO
# class Results(Base):
#    __tablename__ = 'result'
#
#    id = Column(Integer, primary_key=True, autoincrement=True)
