#!/usr/bin/env python3

"""ssl_train.py: Training od ssl model"""
__author__      = "Jan Polisensky"







import Database
from ssl_collector import SSL_loader
import json






d = Database.Database("domains")
collection = d.return_collection("goodDomains")

domain_list = []
for domain in collection.find():
        domain_list.append(domain['name'])
        
        

print(len(domain_list))

loader = SSL_loader(10)

# optimal ~ 220 threads
data = loader.parallel_loader(domain_list, 250)

print("Exited...")

rating_json = json.dumps(data, indent = 4, sort_keys=True, default=str)

print("Returned from analyzer, dumping big juicy JSON")

with open('ssl_good_colected.json', "w") as outfile:
        outfile.write(rating_json)