""" File: Net.py
    Author: Jan Polisensky
    ----
    Modules for neural network training
"""
import os
os.environ['TF_CPP_MIN_LOG_LEVEL'] = '3' 
import torch.nn as nn
import torch.nn.functional as F
import torch
import torch.optim as optim




'''		
Class: Net
pytorch definition of neural network structure

'''       
class Net(nn.Module):

    # Network structure definition
    def __init__(self):         
        super().__init__()
        self.fc1 = nn.Linear(13, 1000)
        self.fc2 = nn.Linear(1000, 500)
        self.fc3 = nn.Linear(500, 1)


    # Data flow definition
    def forward(self, x):
        x = F.relu(self.fc1(x))
        x = F.relu(self.fc2(x))
        return torch.sigmoid(self.fc3(x)) # For binary classification is sigmoid best



