"""request parsers for domainradar api"""
__author__      = "Doktor Databaze"

from flask_restx.reqparse import RequestParser

# pagination parser
pagination = RequestParser()
pagination.add_argument('page', type=int, default=1, help='Page number', location='args')
pagination.add_argument('per_page', type=int, default=20, help='Results per page', location='args')

# filter, sort, group parser
# ex.: ?q=google.com&filter=badness:gt:20,badness:le:90,country:not:cn&sort=-domain,badness&group=country
filter_sort = RequestParser()
filter_sort.add_argument('q', type=str, help='Search query', location='args')
filter_sort.add_argument('filter', type=str, help='Filter', location='args')
filter_sort.add_argument('sort', type=str, default='-id', help='Sort', location='args')
filter_sort.add_argument('group', type=str, help='Group', location='args')