import logging
import json

from flask import request, current_app
from flask_restx import Resource

from api.apiConfig import api
from database import db
from database.models import OffenseSource

from modules.AlchemyEncoder import AlchemyEncoder

from sqlalchemy import exc

log = logging.getLogger(__name__)
ns = api.namespace('offense_sources', description='Offense Sources')


logger = logging.getLogger('domainradar')






@ns.route('')
class OffenseSources(Resource):
    def get(self):
        """
        Displays all the offensce sources
        """

        try:
            offense_sources = json.dumps(OffenseSource.query.all(), cls=AlchemyEncoder)
            return {'items': offense_sources}
        except exc.SQLAlchemyError as e:
            logger.error(e)
            return {'items': None}
