# FETA DomainRadar

## Requirements
- Python 3
- PIP for Python 3

To install required python packages, type:
```
pip3 install -r requirements.txt
```

**NOTE:** It is expected that you have running instances of IBM QRadar SIEM (or IBM QRadar CE) and Suricata IDS. The suricata must be configured to process DNS traffic and forward DNS-related Syslog messages to the QRadar. The QRadar API MUST be accessible from DomainRadar. You also need to create an authentication token for DomainRadar inside the QRadar Console. If you do not configure the above-mentioned, you will only be able to work with an empty or with the example database. Without the connection to QRadar API, DomainRadar can NOT load new data.


## Configuration
In `config.ini`, specify:
- `API_URL` - the URL of your QRadar API
- `SEC_TOKEN` - authentication token

To use a different URL than `http://localhost:5000`:
- Open the `app.py` file.
- Edit the `host` and `port` parameters under `app.run()` method call.


## Example database
Optionally, you can start with an example-filled database:
- `cp EXAMPLE.db domainradar.db`
To start with an empty database, you may skip the step or delete the `domainradar.db` file later.


## Usage
- Run `python3 app.py`
- DomainRadar API should be available at http://localhost:5000
- To run the client with the user interface, see `../client` directory
