export type range = [number | undefined, number | undefined]

export type Filter<T> = (item: T) => boolean

export interface SortCriterion<T> {
  prop: keyof T | ((item: T) => number)
  ascending: boolean
}

export interface SortableObject {
  [prop: string]: number | any
}

export interface Paginated {
  page: number
  per_page: number
  total: number
  pages: number
}

export interface Sievable {
  query: string
  sort: string
  filter: string
}