// Universal operation status

export interface Status {
  [operation: string]: boolean
}

// Loading result types

export interface Result<T> {
  last_result: T | null
}

interface ResultBase {
  success: boolean
  error_description: string
}

export interface Loading extends ResultBase {
  offense_sources_new: number
  offense_sources_updated: number
  offense_sources_total: number
  domain_ip_mappings_new: number
  domain_ip_mappings_total: number
  unique_domains_new: number
  unique_domains_total: number
}

export interface Resolution extends ResultBase {
  domains_resolved_new: number
  domains_resolved_total: number
  domains_remaining: number
  domains_total: number
}

export interface Analysis extends ResultBase {
  domains_analyzed_new: number
  domains_analyzed_total: number
  domains_remaining: number
  domains_total: number
}
