import { Paginated, Sievable, SortableObject } from "../datatypes"

export interface GeoData {
  ip: string
  country: string
  region: string
  city: string
  loc: string
  org: string
}

export interface ModelResult extends SortableObject {
  classifier_name: string
  final: boolean
  badness: number
  accuracy: number
  explanation: string
  error_description: string
  created: Date
}

export interface DomainInfo extends SortableObject {
  domain_name: string
  offense_count: number
  event_flow_count: number
  geo_data: GeoData[]
  results: ModelResult[]
}

export interface Domains extends Paginated, Sievable {
  domains: DomainInfo[] | null
}
